<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Category;
use App\Models\Currency;
use Illuminate\Support\Facades\Validator;
use App\Models\Employer;
use App\Models\Admin;
use App\Models\Note;
use App\Models\Staff;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\DB;

class NoteController extends Controller
{
    public function noteListing(Request $request){
        $currentUser = Auth::user()->id;
        // $userType = $request->user_type;
        $data = array();
        
        $user_type = Employer::where('id', $currentUser)->value('user_type');
        
        if($user_type == 'employer'){
            $notes = Note::where('employer_id', $currentUser)->where('candidate_id', $request->candidate_id)->orderBy('id', 'Desc')->get();
            $noteArray = array();
            foreach($notes as $key => $note) {
                $noteArray[$key]['id'] = $note->id;
                $noteArray[$key]['candidate_id'] = $note->candidate_id;
                $noteArray[$key]['user_id'] = $note->user_id;
                $noteArray[$key]['user_type'] = $note->user_type;
                $noteArray[$key]['note_title'] = $note->note_title;
                $noteArray[$key]['share_with_staff'] = $note->share_with_staff; 
                $noteArray[$key]['note_description'] = $note->note_description;
                $noteArray[$key]['created_at'] = $note->created_at;
                $noteArray[$key]['created_date'] = $note->created_at->format('d M, Y'); // Extracting date
                $noteArray[$key]['created_time'] = $note->created_at->format('H:i:s'); // Extracting time
            }
            
            $data['notes'] = $noteArray;
            
            return Response(['response' => $data, 'message' => 'success', 'status' => 200], 200);
        } else{
            
           $notes = Note::where(function ($query) use ($currentUser) {
                        $query->where('user_id', $currentUser)
                              ->orWhere('user_id', null); // Include null or blank user_id
                    })
                    ->where('employer_id', '22')
                    ->where('candidate_id', $request->candidate_id)
                    ->where('share_with_staff', '1')
                    ->orderBy('id', 'desc')
                    ->get();
            $noteArray = array();
            foreach($notes as $key => $note) {
                $noteArray[$key]['id'] = $note->id;
                $noteArray[$key]['candidate_id'] = $note->candidate_id;
                $noteArray[$key]['user_id'] = $note->user_id;
                $noteArray[$key]['user_type'] = $note->user_type;
                $noteArray[$key]['note_title'] = $note->note_title;
                $noteArray[$key]['share_with_staff'] = $note->share_with_staff; 
                $noteArray[$key]['note_description'] = $note->note_description;
                $noteArray[$key]['created_at'] = $note->created_at;
                $noteArray[$key]['created_date'] = $note->created_at->format('d M, Y'); // Extracting date
                $noteArray[$key]['created_time'] = $note->created_at->format('H:i:s'); // Extracting time
            }
            
            $data['notes'] = $noteArray;
            
            return Response(['response' => $data, 'message' => 'success', 'status' => 200], 200);
        }
        
        
    }
    
    public function noteAdd(Request $request){
        
        $currentUser = Auth::user()->id;
        
        $user_type = Employer::where('id', $currentUser)->value('user_type');
        
        $userType = '';
        
        if($user_type == 'employer'){
            $userType = 'employer';
        } else{
            $userType = 'staff';
        }
        
        $employerCheck = Employer::where('id', $currentUser)->first();
        
        $validator = Validator::make($request->all(), [
            // 'name' => 'required|unique:currencies,name',
            // 'code' => 'required',
            // 'symbol' => 'required',
        ]);
        
        if(!empty($request->all())){
            if($validator->fails()){
                return Response(['response' => $validator->errors(), 'message' => 'error', 'status' => 500], 200);
            } else{
                if(!empty($employerCheck)){
                    Note::create([
                        'candidate_id' => $request->candidate_id,
                        'user_id' => null,
                        'employer_id' => $currentUser,
                        'user_type' => $userType,
                        'note_title' => $request->note_title,
                        'share_with_staff' => $request->share_with_staff,
                        'note_description' => $request->note_description,
                    ]);
                    
                    $noteData = [
                        'candidate_id' => $request->candidate_id,
                        'user_id' => null,
                        'employer_id' => $currentUser,
                        'user_type' => $userType,
                        'note_title' => $request->note_title,
                        'share_with_staff' => $request->share_with_staff,
                        'note_description' => $request->note_description,
                    ];
                } else{
                    $employerOfStaff = Staff::where('id', $currentUser)->value('employer_id');
                    Note::create([
                        'candidate_id' => $request->candidate_id,
                        'user_id' => $currentUser,
                        'employer_id' => $employerOfStaff,
                        'user_type' => $userType,
                        'note_title' => $request->note_title,
                        'share_with_staff' => 1,
                        'note_description' => $request->note_description,
                    ]);
                    
                    $noteData = [
                        'candidate_id' => $request->candidate_id,
                        'user_id' => $currentUser,
                        'employer_id' => $employerOfStaff,
                        'user_type' => $userType,
                        'note_title' => $request->note_title,
                        'share_with_staff' => 1,
                        'note_description' => $request->note_description,
                    ];
                }

    
    
                return Response(['response' => $noteData , 'message' => 'Note Added Successfully' , 'status' => 200],200);
            }
        } else{
            $noteData = Note::where('user_id', $currentUser)->where('user_type', 'employer')->get();
            
            return Response(['response' => $noteData, 'message' => '', 'status' => 200], 200);
        }
        
        
    }
    
    // public function currency_changeStatus($id) {
    //     $currentStatus = Currency::where('id', $id)->value('status');
    //     if($id != ''){
    //         if($currentStatus == 1){
    //             Currency::where('id', $id)->update([
    //                 'status' => 0,
    //             ]);
    //         }else{
    //             Currency::where('id', $id)->update([
    //                 'status' => 1,
    //             ]);
    //         }
            
    //         return Response(['response' => 'Activated Successfully', 'message' => 'Activated Successfully', 'status' => 200],200);
    //     }
    //     return Response(['response' => 'Id not found', 'message' => 'Id not found', 'status' => 500], 200);
    // }
    
    
    public function note_Delete($id){
        $noteData = Note::where('id', $id)->first();
        
        if(!empty($noteData)){
            Note::where('id', $id)->delete();
            
            return Response(['response' => 'Note Deteled Successfully', 'message' => 'success', 'status' => 200], 200);
        }else{
            return Response(['response' => 'No record deleted', 'message' => 'No record deleted', 'status' => 500], 200);
        }
    }
    
    public function note_Edit(Request $request,$id){
        $currentUser = Auth::user()->id;
        $noteData = Note::where('id', $id)->first();
        
        $employerCheck = Employer::where('id', $currentUser)->first();
        
        if(!empty($request->all())){
            $validator = Validator::make($request->all(), [
                // 'name' => 'required',
                // 'code' => 'required',
                // 'symbol' => 'required',
            ]);
            
            if($validator->fails()){
                return Response(['response' => $validator->errors(), 'message' => 'error', 'status' => 500], 200);
            } else{
                
                if(!empty($employerCheck)){
                    Note::where('id', $id)->update([
                        'candidate_id' => $request->candidate_id,
                        'user_id' => null,
                        'employer_id' => $currentUser,
                        'user_type' => $request->user_type,
                        'note_title' => $request->note_title,
                        'share_with_staff' => $request->share_with_staff,
                        'note_description' => $request->note_description,
                    ]);
                    
                    $noteData = Note::where('id', $id)->first();
                    return Response(['response' => $noteData , 'message'=> 'success' , 'status'=> 200 ],200);
                } else{
                    $employerOfStaff = Staff::where('id', $currentUser)->value('employer_id');
                    Note::where('id', $id)->update([
                        'candidate_id' => $request->candidate_id,
                        'user_id' => $currentUser,
                        'employer_id' => $employerOfStaff,
                        'user_type' => $request->user_type,
                        'note_title' => $request->note_title,
                        'share_with_staff' => $request->share_with_staff,
                        'note_description' => $request->note_description,
                    ]);
                    
                    $noteData = Note::where('id', $id)->first();
                    return Response(['response' => $noteData , 'message'=> 'success' , 'status'=> 200 ],200);
                }
                
                
            }
        }else{
             return Response(['response' => $noteData , 'message' => 'sucess', 'status'=>200],200);
        }
    }
    
    // public function is_default($id){
    //     if(!empty($id)){
    //         Currency::where('id', '!=', 0)->update([
    //                     'is_default' => 0,
    //                 ]);
    //         Currency::where('id',$id)->update([
    //                     'is_default' => 1,
    //         ]);

              
    //             $Keyword = Currency::where('id', '!=', 0)->get();
    //         return Response(['response' => $Keyword, 'message' => 'success', 'status' => 200], 200);
    //     }
    //     else{
    //         return Response(['response' => 'No record selected', 'message' => 'error', 'status' => 500], 200);
    //     }
    // }
    
    // public function currency_deactivate($id) {
    //     if($id != ''){
    //         Currency::where('id', $id)->update([
    //             'status' => 0,
    //         ]);
            
    //         return Response(['response' => 'De-activated Successfully', 'message' => 'De-activated Successfully', 'status' => 200], 200);
    //     }
    //     return Response(['response' => 'Id not found', 'message' => 'Id not found', 'status' => 500], 200);
    // }
    
}
