<?php

use App\Http\Controllers\API\AdminController;
use App\Http\Controllers\API\IndustryController;
use App\Http\Controllers\API\JobsController;
use App\Http\Controllers\API\QualificationsController;
use App\Http\Controllers\API\SkillsController;
use App\Http\Controllers\API\DashboardController;
use App\Http\Controllers\API\DesignationController;
use App\Http\Controllers\API\StaffController;
use App\Http\Controllers\API\AuthController;
use App\Http\Controllers\API\CategoryController;
use App\Http\Controllers\API\CandidatesController;
use App\Http\Controllers\API\EmployerController;
use App\Http\Controllers\API\InterviewController;
use App\Http\Controllers\API\OnboardingController;
use App\Http\Controllers\API\EmailTemplateController;
use App\Http\Controllers\API\CurrenciesController;
use App\Http\Controllers\API\NoteController;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/



// Miscellaneous APIs
Route::any('/getconstants', [AdminController::class, 'getConstants']);


Route::controller(AuthController::class)->group(function () {
    Route::post('login', 'login');
    Route::post('register', 'register');
    Route::post('/forgetpassword', 'forgetPassword');

});
Route::post('/resetpassword', [AuthController::class, 'resetPassword']);



// middleware('auth:sanctum')->
Route::prefix('admin')->middleware('auth:sanctum')->group(function () {
    
    Route::controller(DashboardController::class)->group(function () {
        Route::any('/dashboard', 'dashboard');        
    });
    
    
    Route::controller(AdminController::class)->group(function () {
        Route::any('/changeusername', 'admin_changeusername');
        Route::post('/changeemail', 'admin_changeemail');
        Route::post('/changepassword', 'admin_changepassword');
        Route::post('/changewebsitelogo', 'admin_changeWebsiteLogo');
        Route::post('/changeprofilepicture', 'admin_changeProfilePicture');
        
        
        Route::post('/interviewprocesses/index', 'admin_interviewProcesses');
        Route::post('/interviewprocesses/add', 'admin_addInterviewProcess');
        Route::post('/interviewprocesses/edit/{slug}', 'admin_editInterviewProcess');
        Route::post('/interviewprocesses/delete/{slug}', 'admin_deleteInterviewProcess');


        Route::post('/interviewstatus/index', 'admin_interviewStatus');
        Route::post('/interviewstatus/add', 'admin_addInterviewStatus');
        Route::post('/interviewstatus/edit/{slug}', 'admin_editInterviewStatus');
        Route::post('/interviewstatus/delete/{slug}', 'admin_deleteInterviewStatus');
        
        
        // Assign user to process APIs
        Route::post('/assignusertoprocess/index', 'admin_assignUserToProcessListing');
        Route::post('/assignusertoprocess/add', 'admin_addUserToProcess');
        Route::post('/assignusertoprocess/edit/{id}', 'admin_editUserToProcess');
        Route::post('/assignusertoprocess/delete/{id}', 'admin_deleteUserToProcess');
        Route::post('/assignusertoprocess/activate/{slug}', 'admin_activateUserToProcess');
        Route::post('/assignusertoprocess/deactivate/{slug}', 'admin_deactivateUserToProcess');
        Route::any('/assignusertoprocess/multipleaction', 'admin_multipleActionsUserToProcess');
        
        
        
        // Manage Sub-admin APIs
        Route::post('/subadmin/index', 'admin_subadminsListing');
        Route::post('/subadmin/add', 'admin_addSubadmin');
        Route::post('/subadmin/edit/{slug}', 'admin_editSubadmin');
        Route::post('/subadmin/delete/{slug}', 'admin_deleteSubadmin');
        Route::post('/subadmin/activate/{slug}', 'admin_activateSubadmin');
        Route::post('/subadmin/deactivate/{slug}', 'admin_deactivateSubadmin');
        
        
        //general Setting
        Route::any('/generalsettings', 'saveGeneralSetting');
        
        Route::any('/logout', 'logout');

    });
    
    
    
    
    // Jobs Controller
    Route::controller(JobsController::class)->group(function () {
        Route::any('/jobs/listing', 'listing');
        Route::any('/jobs/postjob', 'admin_postJob');
        
        
        Route::any('/jobs/user/index', 'admin_listing');
        Route::post('/jobs/user/edit/{slug}', 'admin_editJob');
        Route::post('/jobs/user/delete/{slug}', 'admin_deleteJob');
        Route::post('/jobs/user/activate/{slug}', 'activateJob');
        Route::post('/jobs/user/deactivate/{slug}', 'deactivateJob');
        
        
        Route::post('/jobs/getappliedcandidatelist/{slug}', 'getAppliedCandidateListforJob');
        Route::any('/jobs/user/appliedcandidatelistforjob', 'appliedCandidateListForJob');
    });
    
    
    // Interview Controller
    Route::controller(InterviewController::class)->group(function () {
        // Route::any('/job/scheduleinterview', 'interviewSchedule');
        Route::any('/job/scheduleinterview/{id}/{job_id}', 'interviewSchedule');
        Route::any('/candidate/interviewstatus/{id}', 'candidateInterviewStatus');
        Route::any('/candidate/assignedinterviewstouser/{id}', 'interviewAssignedToUser');
        Route::any('/candidate/addcandidatefeedback', 'addCandidateInterviewFeedback');
        Route::any('/candidate/addinterviewcomment', 'candidateInterviewComment');
        Route::any('/candidate/interviewcompletionstatus/{id}', 'interviewCompletionStatus');
        Route::any('/candidate/interviewcancelation', 'interviewCancelation');
        Route::any('/candidate/interviewrescheduled', 'interviewRescheduled');
        Route::any('/candidate/get-interview-reschedule-details', 'getInterviewDetails');


        
    });
    
    
    
    // Candidates Controllers 
    Route::controller(CandidatesController::class)->group(function () {
        Route::any('/candidates/listing', 'listing');
        Route::any('/candidates/statuschange/{slug}', 'candidateStatusChange');
        Route::any('/candidates/feedback', 'candidateFeedback');
        Route::any('/candidate/addcomment', 'addComment');
        Route::any('/candidate/getcommentlogs/{id}', 'getCommentLog');
        Route::any('/candidates/interviewschedule/{id}', 'candidateInterviewSchedule');
        Route::any('/getusersforprocess/{id}', 'getUserlistForprocess');
        
        Route::any('/getprocessname/{id}', 'getProcessName');
        Route::any('/getuserdata/{id}', 'getUserName');
        Route::any('/getinterviewjourneystatus', 'candidateInterviewStatus');
        
        Route::any('/candidates/selectedcandidates', 'selectedCandidates');



    });
    
    //Onboarding Controller(secured)
    Route::controller(OnboardingController::class)->group(function () {
        Route::any('/candidates/sendofferletteremail', 'sendOfferLetterEmail');
        Route::any('/offerinitialdata', 'offerInitialData');
        Route::any('/candidates/sendonboardingform', 'onBoardingForm');
        Route::any('/candidates/offerdraftdata', 'offerDraftData');
        Route::any('/candidates/get_candidate_details_after_onboarding', 'get_candidate_details_after_onboarding');
        Route::any('/employer/setup-preferences-setting', 'setup_preferences_setting');
        Route::any('/employer/remove-preference-section', 'remove_preference_section');
   
    });



    // Categories controller
    Route::controller(CategoryController::class)->group(function () {
        Route::any('/category/index', 'listing');
        Route::any('/category/add', 'addCategory');
        Route::any('/category/edit/{slug}', 'editCategory');
        Route::any('/category/delete/{slug}', 'deleteCategory');   
        Route::any('/category/activate/{slug}', 'activateCategory'); 
        Route::any('/category/deactivate/{slug}', 'deactivateCategory');      
    });
    
    
    // Qualification controller
    Route::controller(QualificationsController::class)->group(function () {
        Route::any('/qualifications/index', 'listing');
        Route::any('/qualifications/add', 'addQualification');
        Route::any('/qualifications/edit/{slug}', 'editQualification');
        Route::any('/qualifications/delete/{slug}', 'deleteQualification');   
        Route::any('/qualifications/activate/{slug}', 'activateQualification'); 
        Route::any('/qualifications/deactivate/{slug}', 'deactivateQualification');      
    });
    
    
    // Skill controller
    Route::controller(SkillsController::class)->group(function () {
        Route::any('/skills/index', 'listing');
        Route::any('/skills/add', 'addSkill');
        Route::any('/skills/edit/{slug}', 'editSkill');  
        Route::any('/skills/delete/{slug}', 'deleteSkill');   
        Route::any('/skills/activate/{slug}', 'activateSkill'); 
        Route::any('/skills/deactivate/{slug}', 'deactivateSkill');
    });
    
    
    // Designation controller
    Route::controller(DesignationController::class)->group(function () {
        Route::any('/designations/index', 'listing');
        Route::any('/designations/add', 'addDesignation');
        Route::any('/designations/edit/{slug}', 'editDesignation');  
        Route::any('/designations/delete/{slug}', 'deleteDesignation');   
        Route::any('/designations/activate/{slug}', 'activateDesignation'); 
        Route::any('/designations/deactivate/{slug}', 'deactivateDesignation');
    });
    

    // Industry controller
    Route::controller(IndustryController::class)->group(function () {
        Route::any('/industry/index', 'listing');
        Route::any('/industry/add', 'addIndustry');
        Route::any('/industry/edit/{slug}', 'editIndustry');
        Route::any('/industry/delete/{slug}', 'deleteIndustry');   
        Route::any('/industry/activate/{slug}', 'activateIndustry'); 
        Route::any('/industry/deactivate/{slug}', 'deactivateIndustry');      
    });
    
    // Employer Controller
    Route::controller(EmployerController::class)->group(function () {
           Route::post('/employer/changewebsitelogo', 'employer_changeWebsiteLogo');
    });
    
    
        // Staff Controller
    Route::controller(StaffController::class)->group(function () {
        Route::post('/user/staff', 'listing');
        Route::post('/user/staff/add', 'addStaff');
        Route::post('/staff/edit/{slug}', 'editStaff');
        
        Route::any('/user/staff/activate/{slug}', 'activateStaff'); 
        Route::any('/user/staff/deactivate/{slug}', 'deactivateStaff');
        Route::any('/user/staff/delete/{slug}', 'deleteStaff');  
    });
    
    
    
    //Email Controller
    Route::controller(EmailTemplateController::class)->group(function () {
       Route::any('/emailtemplate/index', 'listingEmailTemplate');
       Route::any('/emailtemplate/editemailtemplate/{slug}', 'editEmailTemplate');
       Route::any('/emailtemplate/testemailtemplate/{slug}', 'testEmailTemplate');
       Route::any('/emailtemplate/offer-letter/getEmailTemplatePreview/{id}', 'getOfferLetterEmailTemplatePreview');
       Route::any('/emailtemplate/onboarding-form/getEmailTemplatePreview/{id}', 'getOnboardingFormEmailTemplatePreview');
       Route::any('/emailtemplate/interview-schedule/getEmailTemplatePreview/{id}', 'getInterviewScheduleEmailTemplatePreview');
       Route::any('/emailtemplate/interview-cancellation/getEmailTemplatePreview/{id}', 'getInterviewCancellationEmailTemplatePreview');
    });

    
    
    //Currency Controller
    Route::controller(CurrenciesController::class)->group(function () {
       Route::any('/currencies/currencylisting', 'currencyListing');
       Route::any('/currencies/currencyadd', 'currencyAdd');
       Route::any('/currencies/currencychangestatus/{id}', 'currency_changeStatus');
    //   Route::any('/currencies/currencydeactivate/{id}', 'currency_deactivate');
       Route::any('/currencies/currencydelete/{id}', 'currency_Delete');
       Route::any('/currencies/currencyedit/{id}', 'currency_Edit');
       Route::any('/currencies/isdefault/{id}', 'is_default');
    });
    
    
    //Note Controller
    Route::controller(NoteController::class)->group(function () {
       Route::any('/user/notelisting', 'noteListing');
       Route::any('/user/noteadd', 'noteAdd');
       Route::any('/user/notedelete/{id}', 'note_Delete');
       Route::any('/user/noteedit/{id}', 'note_Edit');
    });
    
    
});

// Employer Controller
Route::controller(EmployerController::class)->group(function () {
    Route::post('/user/login', 'employerLogin');
    Route::post('/user/register', 'employerRegister');
    Route::post('/employer/forgetpassword', 'forgetPassword');
    Route::any('/employer/resetpassword', 'resetPassword');
       
});

// Staff Controller
Route::controller(StaffController::class)->group(function () {
    Route::post('/user/staff', 'listing');
    Route::post('/user/staff/add', 'addStaff');
    Route::post('/staff/edit/{slug}', 'editStaff');
    Route::post('/user/staff/login', 'staffLogin');
    Route::any('/user/staff/activate/{slug}', 'activateStaff'); 
    Route::any('/user/staff/deactivate/{slug}', 'deactivateStaff');
    Route::any('/user/staff/delete/{slug}', 'deleteStaff');
    Route::any('/staff/forgetpassword', 'forgetPassword');
    Route::any('/staff/resetpassword', 'resetPassword');
});

// Onboarding controller
Route::controller(OnboardingController::class)->group(function () {
    Route::any('/candidates/getcandidatedetails', 'getCandidateDetails');
    Route::any('/savePersonalDetails', 'savePersonalDetails');
    Route::any('/candidates/academicdetailsdata/{id}', 'academicDetailsData');
    Route::any('/candidates/saveacademicdetails/{slug}', 'saveAcademicDetails');
    Route::any('/candidates/fetchpersonaldetails', 'fetchPersonalDetails');
    Route::any('/candidates/getexperience/{id}', 'getExperience');
    Route::any('/candidates/saveexperience/{id}', 'saveExperience');
    Route::any('/candidates/getdocument/{id}', 'getDocument');
    Route::any('/candidates/savedocuments/{id}', 'saveDocuments');
    Route::any('/candidates/profilesummary/{id}', 'getProfileSummary');
    Route::any('/candidates/get-preference-data', 'get_preference_data');
    Route::any('/candidates/savepreferences/{id}', 'savePreferences');
    Route::any('/candidates/getofferletterdata', 'getOfferLetterData');
    Route::any('/candidates/changeofferletterstatus', 'changeOfferLetterStatus');
   
});


// Frontend routes
Route::any('/jobs/listing', [JobsController::class, 'listing']);
Route::any('/jobs/description/{slug}', [JobsController::class, 'jobDescription']);
Route::any('/jobs/jobapply/{slug}', [JobsController::class, 'jobApply']);
Route::any('/check-employer-existence', [EmployerController::class, 'getEmployerCheck']);


