<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\CandidateJobApply;
use App\Models\CandidateEducation;
use App\Models\CandidateExperience;
use App\Models\SelectedCandidate;
use App\Models\Job;
use App\Models\Admin;
use App\Models\Employer;
use App\Models\Staff;
use App\Models\Process;
use App\Models\Skill;
use App\Models\CandidateInterviewResponse;
use App\Models\CandidateInterviewSchedule;
use App\Models\Notification;
use Illuminate\Http\Request;
use App\Models\Qualification;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

use Carbon\Carbon;


class DashboardController extends Controller
{
    //
    public function dashboard() {
        
        $currentUser = Auth::user()->id;
        $AdminCheck = Admin::where('id', $currentUser)->first();
        $EmployerCheck = Employer::where('id', $currentUser)->first();
        $StaffCheck = Staff::where('id', $currentUser)->first();

        // Check for admin
        if (!empty($AdminCheck)) {
            $latestApplications = CandidateJobApply::orderBy('created_at', 'desc')->take(100)->get();
    
            $latestApplicationData = array();
        
            foreach ($latestApplications as $key => $value) {
                $latestApplicationData[$key]['id'] = $value->id;
                $latestApplicationData[$key]['job_form_id'] = $value->job_form_id;
                $latestApplicationData[$key]['first_name'] = $value->first_name;
                $latestApplicationData[$key]['middle_name'] = $value->middle_name;
                $latestApplicationData[$key]['last_name'] = $value->last_name;
                
                if($value->gender == 1){
                    $latestApplicationData[$key]['gender'] = 'Male';
                } else if($value->gender == 2){
                    $latestApplicationData[$key]['gender'] = 'Female';
                }else{
                    $latestApplicationData[$key]['gender'] = 'Other';
                }
                
                $latestApplicationData[$key]['profile_image'] = $value->profile_image;
                $latestApplicationData[$key]['email_address'] = $value->email;
                $latestApplicationData[$key]['contact'] = $value->contact_number;
                $latestApplicationData[$key]['date_of_birth'] = $value->date_of_birth;
                $latestApplicationData[$key]['martial_status'] = $value->martial_status;
                $latestApplicationData[$key]['physically_challenged'] = $value->physically_challenged;
                $latestApplicationData[$key]['address'] = $value->address;
        
                // Fetch the job title
                $job = Job::find($value->job_form_id);
                if ($job) {
                    $latestApplicationData[$key]['job_name'] = $job->title;
                    $latestApplicationData[$key]['slug'] = $job->slug;
                } else {
                    $latestApplicationData[$key]['job_name'] = 'Job Not Available';
                    $latestApplicationData[$key]['slug'] = null; // Or handle appropriately
                }
        
                $educations = CandidateEducation::where('candidate_job_apply_id', $value->id)->get();
                
                $educationData = array();
                foreach ($educations as $eduKey => $education) {
                    $educationData[$eduKey]['id'] = $education->id;
                    $educationData[$eduKey]['qualification_id'] = Qualification::find($education->qualification_id)->qualification_name;
                    $educationData[$eduKey]['course'] = $education->course;
                    $educationData[$eduKey]['school_college_city'] = $education->school_college_city;
                    $educationData[$eduKey]['university_board'] = $education->university_board;
                    $educationData[$eduKey]['passing_year'] = $education->passing_year;
                }
                $latestApplicationData[$key]['education'] = $educationData;
        
                $experience = CandidateExperience::where('candidate_job_apply_id', $value->id)->get();
                $experienceData = array();
                foreach ($experience as $expKey => $exp) {
                    $experienceData[$expKey]['id'] = $exp->id;
                    $experienceData[$expKey]['organisation_name'] = $exp->organisation_name;
                    $experienceData[$expKey]['designation'] = $exp->designation;
                    $experienceData[$expKey]['reason_of_leaving'] = $exp->reason_of_leaving;
                    $experienceData[$expKey]['start_date'] = $exp->start_date;
                    $experienceData[$expKey]['end_date'] = $exp->end_date;
                }
                $latestApplicationData[$key]['experience'] = $experienceData;
                $latestApplicationData[$key]['created_at'] = format_date($value->created_at);
            }
        
            $activeJobs = Job::where('job_status', 1)->orderBy('created_at', 'desc')->take(10)->get();
            $activeJobsData = array();
            foreach ($activeJobs as $activeJobKey => $value) {
                $activeJobsData[$activeJobKey]['id'] = $value->id;
                $activeJobsData[$activeJobKey]['job_name'] = $value->title;
                $activeJobsData[$activeJobKey]['min_exp'] = $value->min_exp;
                $activeJobsData[$activeJobKey]['max_exp'] = $value->max_exp;
                $activeJobsData[$activeJobKey]['created_at'] = format_date($value->created_at);
                $activeJobsData[$activeJobKey]['slug'] = $value->slug;
            }
        
            $upcomingInterview = CandidateInterviewResponse::orderBy('created_at', 'desc')->take(10)->get();
            $upcomingInterviewData = array();
            foreach ($upcomingInterview as $interviewKey => $value) {
                $upcomingInterviewData[$interviewKey]['id'] = $value->id;
            
                // Fetch the candidate's first and last name
                $candidate = CandidateJobApply::where('id', $value->candidate_id)->select('first_name', 'last_name')->first();
                $upcomingInterviewData[$interviewKey]['candidate_name'] = $candidate ? $candidate->first_name . ' ' . $candidate->last_name : '';
            
                // Fetch the interviewer's first and last name
                $interviewer = Admin::where('id', $value->interviewer_id)->select('first_name', 'last_name')->first();
                $upcomingInterviewData[$interviewKey]['interviewer_name'] = $interviewer ? $interviewer->first_name . ' ' . $interviewer->last_name : '';
                $upcomingInterviewData[$interviewKey]['job_id'] = $value->job_id;
                $upcomingInterviewData[$interviewKey]['interview_date'] = $value->interview_date
    ? Carbon::parse($value->interview_date)->toDateString()
    : "Interview not scheduled";
                $upcomingInterviewData[$interviewKey]['created_at'] = format_date($value->created_at);
                $upcomingInterviewData[$interviewKey]['start_time'] = $value->start_time;
                
                
                $educations = CandidateEducation::where('candidate_job_apply_id', $value->candidate_id)->get();
                
                $educationData = array();
                foreach ($educations as $eduKey => $education) {
                    $educationData[$eduKey]['id'] = $education->id;
                    $educationData[$eduKey]['qualification_id'] = Qualification::find($education->qualification_id)->qualification_name;
                    $educationData[$eduKey]['course'] = $education->course;
                    $educationData[$eduKey]['school_college_city'] = $education->school_college_city;
                    $educationData[$eduKey]['university_board'] = $education->university_board;
                    $educationData[$eduKey]['passing_year'] = $education->passing_year;
                }
                
                $upcomingInterviewData[$interviewKey]['education'] = $educationData;
    
                $experience = CandidateExperience::where('candidate_job_apply_id', $value->candidate_id)->get();
                $experienceData = array();
                foreach ($experience as $expKey => $exp) {
                    $experienceData[$expKey]['id'] = $exp->id;
                    $experienceData[$expKey]['organisation_name'] = $exp->organisation_name;
                    $experienceData[$expKey]['designation'] = $exp->designation;
                    $experienceData[$expKey]['reason_of_leaving'] = $exp->reason_of_leaving;
                    $experienceData[$expKey]['start_date'] = $exp->start_date;
                    $experienceData[$expKey]['end_date'] = $exp->end_date;
                }
                
                $upcomingInterviewData[$interviewKey]['experience'] = $experienceData;
           
               
            }
            
            return Response(['response' => ['latestApplications' => $latestApplications, 'activeJobs' => $activeJobsData, 'upcomingInterview' => $upcomingInterviewData], 'status' => 200], 200);

        }
        
        // Check for employer
        if(!empty($EmployerCheck)){
            $latestApplications = CandidateJobApply::where('employer_id', $currentUser)->orderBy('created_at', 'desc')->take(5)->get();
    
            $latestApplicationData = array();
        
            foreach ($latestApplications as $key => $value) {
                
                $latestApplicationData[$key]['additional_data'] = $value->custom_fields_data ? json_decode($value->custom_fields_data, true) : [];
                $latestApplicationData[$key]['id'] = $value->id;
                $latestApplicationData[$key]['job_form_id'] = $value->job_form_id;
                $latestApplicationData[$key]['name'] = $value->first_name . ' ' . $value->middle_name . ' ' . $value->last_name;
                $latestApplicationData[$key]['phone'] = $value->contact_number;
                $latestApplicationData[$key]['first_name'] = $value->first_name;
                $latestApplicationData[$key]['middle_name'] = $value->middle_name;
                $latestApplicationData[$key]['last_name'] = $value->last_name;
                $latestApplicationData[$key]['contact_number'] = $value->contact_number;
                            
                if($value->gender == 1){
                    $latestApplicationData[$key]['gender'] = 'Male';
                } else if($value->gender == 2){
                    $latestApplicationData[$key]['gender'] = 'Female';
                }else{
                    $latestApplicationData[$key]['gender'] = 'Other';
                }
                    
                if(!empty($value->profile_img)){
                    $latestApplicationData[$key]['profile_image'] = DISPLAY_FULL_PROFILE_IMAGE_PATH.$value->profile_img;
                }else{
                    $latestApplicationData[$key]['profile_image'] = "";
                }
                
                if(!empty($value->document_cv)){
                    $latestApplicationData[$key]['cv_document'] = DISPLAY_RESUME_PATH.$value->document_cv;
                } else{
                    $latestApplicationData[$key]['cv_document'] = "";
                }
                
                $latestApplicationData[$key]['email'] = $value->email;
                $latestApplicationData[$key]['email_address'] = $value->email;
                
                if(!empty($value->date_of_birth)){
                    $latestApplicationData[$key]['date_of_birth'] = date('d M Y',strtotime($value->date_of_birth));
                } else{
                    $latestApplicationData[$key]['date_of_birth'] = '';
                }
                
                
                
                if($value->martial_status == 1){
                    $latestApplicationData[$key]['martial_status'] = "Single";
                } else if($value->martial_status == 2){
                    $latestApplicationData[$key]['martial_status'] = "Married";
                } else if($value->martial_status == 3){
                    $latestApplicationData[$key]['martial_status'] = "Divorced";
                }else{
                    $latestApplicationData[$key]['martial_status'] = "N/A";
                }
                    
                if($value->physically_challenged == 1){
                    $latestApplicationData[$key]['physically_challenged'] = "Yes";
                } else if($value->physically_challenged == 2){
                    $latestApplicationData[$key]['physically_challenged'] = "No";
                } else if($value->physically_challenged == 3){
                    $latestApplicationData[$key]['physically_challenged'] = "Prefer not to say";
                }else{
                    $latestApplicationData[$key]['physically_challenged'] = "N/A";
                }
                $latestApplicationData[$key]['address'] = $value->address;
                $latestApplicationData[$key]['applied_date'] = $value->created_at->format('d-m-Y');
                // Fetch the job title
                $job = Job::find($value->job_form_id);
                if ($job) {
                    $latestApplicationData[$key]['job_name'] = $job->title;
                    $latestApplicationData[$key]['slug'] = $job->slug;
                } else {
                    $latestApplicationData[$key]['job_name'] = 'Job Not Available';
                    $latestApplicationData[$key]['slug'] = null; // Or handle appropriately
                }
                
                $latestApplicationData[$key]['cover_letter_title'] = $value->cover_letter_title ?? "N/A";
                $latestApplicationData[$key]['cover_letter_description'] = $value->cover_letter_description ?? "N/A";
        
                $educations = CandidateEducation::where('candidate_job_apply_id', $value->id)->get();
                
                $educationData = array();
                foreach ($educations as $eduKey => $education) {
                    $educationData[$eduKey]['id'] = $education->id;
                    // $educationData[$eduKey]['qualification_id'] = Qualification::find($education->qualification_id)->qualification_name;
                    
                    $qualificationName = Qualification::where('id', $education->qualification_id)->value('qualification_name');
                    if(!empty($qualificationName)){
                        $educationData[$eduKey]['qualification_id'] = $qualificationName;
                    } else{
                        $educationData[$eduKey]['qualification_id'] = $education->designation;
                    }
                    
                    $educationData[$eduKey]['course'] = $education->course;
                    $educationData[$eduKey]['school_college'] = $education->school_college;
                    $educationData[$eduKey]['city'] = $education->city;
                    $educationData[$eduKey]['university_board'] = $education->university_board;
                    $educationData[$eduKey]['passing_year'] = $education->passing_year;
                }
                $latestApplicationData[$key]['education'] = $educationData;
        
                $experience = CandidateExperience::where('candidate_job_apply_id', $value->id)->get();
                $experienceData = array();
                foreach ($experience as $expKey => $exp) {
                    $experienceData[$expKey]['id'] = $exp->id;
                    $experienceData[$expKey]['organisation_name'] = $exp->organisation_name;
                    $experienceData[$expKey]['designation'] = $exp->designation;
                    $experienceData[$expKey]['reason_of_leaving'] = $exp->reason_of_leaving;
                    $experienceData[$expKey]['start_date'] = date('d M Y',strtotime($exp->start_date));
                    $experienceData[$expKey]['end_date'] = date('d M Y',strtotime($exp->end_date));
                }
                $latestApplicationData[$key]['experience'] = $experienceData;
                $latestApplicationData[$key]['created_at'] = format_date($value->created_at);
            }
        
            $activeJobs = Job::where('employer_id', $currentUser)->where('job_status', 1)->orderBy('created_at', 'desc')->take(10)->get();
            $activeJobsData = array();
            foreach ($activeJobs as $activeJobKey => $value) {
                $activeJobsData[$activeJobKey]['id'] = $value->id;
                $activeJobsData[$activeJobKey]['job_name'] = $value->title;
                $activeJobsData[$activeJobKey]['min_exp'] = $value->min_exp;
                $activeJobsData[$activeJobKey]['max_exp'] = $value->max_exp;
                $activeJobsData[$activeJobKey]['created_at'] = format_date($value->created_at);
                $activeJobsData[$activeJobKey]['slug'] = $value->slug;
            }
        
            // $upcomingInterview = CandidateInterviewSchedule::where('assigned_by', $currentUser)->whereMonth('created_at', now()->month)
            //                     ->whereYear('created_at', now()->year)
            //                     ->orderBy('created_at', 'desc')
            //                     // ->take(10)
            //                     ->get();
            
            
            $upcomingInterview = CandidateInterviewSchedule::where('assigned_by', $currentUser)
                                ->whereMonth('created_at', now()->month)
                                ->whereYear('created_at', now()->year)
                                ->where('interview_date', '>', now()->toDateString()) // Filter interviews after today
                                ->orderBy('interview_date', 'asc') // Order by nearest upcoming interviews
                                ->get();

            
            // return Response(['response' => $upcomingInterview, 'message' => 'done', 'status' => 200], 200);

            $upcomingInterviewData = array();
            foreach ($upcomingInterview as $interviewKey => $value) {
                $upcomingInterviewData[$interviewKey]['id'] = $value->id;
            
                // Fetch the candidate's first and last name
                $candidate = CandidateJobApply::where('id', $value->candidate_id)->select('first_name', 'last_name')->first();
                $upcomingInterviewData[$interviewKey]['candidate_name'] = $candidate ? $candidate->first_name . ' ' . $candidate->last_name : '';
                $upcomingInterviewData[$interviewKey]['candidate_id'] = $value->candidate_id;
                
                
                // Fetch the interviewer's first and last name
                $assignedToIds = json_decode($value->assigned_to, true); // Decode JSON to array

                // Ensure it's an array (some cases might have a single value as a string)
                if (!is_array($assignedToIds)) {
                    $assignedToIds = [$assignedToIds]; // Convert single value to an array
                }
                
                // Fetch staff names for all assigned IDs
                $interviewers = Staff::whereIn('id', $assignedToIds)
                    ->select('first_name', 'last_name')
                    ->get()
                    ->map(function ($staff) {
                        return $staff->first_name . ' ' . $staff->last_name;
                    })
                    ->toArray();
                
                // Convert array to string (comma-separated if multiple)
                $interviewerNames = implode(', ', $interviewers);

            
                
                // $interviewer = Staff::where('id', $value->assigned_to)->select('first_name', 'last_name')->first();
                $employer = Employer::where('id', $value->assigned_by)->select('first_name', 'last_name')->first();
                $process = Process::where('id', $value->process_id)->value('process_name');
                $upcomingInterviewData[$interviewKey]['interviewer_name'] = $interviewerNames;
                $upcomingInterviewData[$interviewKey]['interviewer_id'] = json_decode($value->assigned_to, true);
                $upcomingInterviewData[$interviewKey]['employer_id'] = $value->assigned_by;
                $upcomingInterviewData[$interviewKey]['employer_name'] = $employer ? $employer->first_name . ' ' . $employer->last_name : '';
                $upcomingInterviewData[$interviewKey]['job_id'] = $value->job_id;
                $jobName = Job::where('id', $value->job_id)->value('title');
                $upcomingInterviewData[$interviewKey]['job_name'] = $jobName;
                $upcomingInterviewData[$interviewKey]['process_id'] = $value->process_id;
                $upcomingInterviewData[$interviewKey]['process_name'] = $process;
                $upcomingInterviewData[$interviewKey]['interview_date'] = $value->interview_date ? format_date($value->interview_date) : "Interview not scheduled";
                $upcomingInterviewData[$interviewKey]['interview_date_raw'] = \Carbon\Carbon::parse($value->interview_date)->format('Y-m-d');
                $upcomingInterviewData[$interviewKey]['created_at'] = format_date($value->created_at);
                $upcomingInterviewData[$interviewKey]['start_time'] = date("g:i A", strtotime($value->start_time . ":00"));
                
                
                $educations = CandidateEducation::where('candidate_job_apply_id', $value->candidate_id)->get();
                
                $educationData = array();
                foreach ($educations as $eduKey => $education) {
                    $educationData[$eduKey]['id'] = $education->id;
                    $educationData[$eduKey]['qualification_id'] = Qualification::find($education->qualification_id)->qualification_name;
                    $educationData[$eduKey]['course'] = $education->course;
                    $educationData[$eduKey]['school_college'] = $education->school_college;
                    $educationData[$eduKey]['city'] = $education->city;
                    $educationData[$eduKey]['university_board'] = $education->university_board;
                    $educationData[$eduKey]['passing_year'] = $education->passing_year;
                }
                
                $upcomingInterviewData[$interviewKey]['education'] = $educationData;
    
                $experience = CandidateExperience::where('candidate_job_apply_id', $value->candidate_id)->get();
                $experienceData = array();
                foreach ($experience as $expKey => $exp) {
                    $experienceData[$expKey]['id'] = $exp->id;
                    $experienceData[$expKey]['organisation_name'] = $exp->organisation_name;
                    $experienceData[$expKey]['designation'] = $exp->designation;
                    $experienceData[$expKey]['reason_of_leaving'] = $exp->reason_of_leaving;
                    $experienceData[$expKey]['start_date'] = date('d M Y',strtotime($exp->start_date));
                    $experienceData[$expKey]['end_date'] = date('d M Y',strtotime($exp->end_date));
                }
                
                $upcomingInterviewData[$interviewKey]['experience'] = $experienceData;
            }
            
            
            $candidateOfferedJobData = CandidateJobApply::where('employer_id', $currentUser)->where('offer_letter_status', 1)->get();
            
            $candidateOfferedJob = array();
            foreach($candidateOfferedJobData as $offeredDataKey => $value){
                $candidateOfferedJob[$offeredDataKey]['candidate_id'] = $value->id;
                $candidateOfferedJob[$offeredDataKey]['name'] = $value->first_name . ' ' . $value->middle_name . ' ' . $value->last_name;
                $candidateOfferedJob[$offeredDataKey]['first_name'] = $value->first_name;
                $candidateOfferedJob[$offeredDataKey]['middle_name'] = $value->middle_name;
                $candidateOfferedJob[$offeredDataKey]['last_name'] = $value->last_name;
                $candidateOfferedJob[$offeredDataKey]['email_address'] = $value->email;
                $candidateOfferedJob[$offeredDataKey]['email'] = $value->email;
                $candidateOfferedJob[$offeredDataKey]['phone'] = $value->contact_number;
                $candidateOfferedJob[$offeredDataKey]['contact_number'] = $value->contact_number;
                $candidateOfferedJob[$offeredDataKey]['date_of_birth'] = date('d M Y', strtotime($value->date_of_birth));
                
                if(!empty($value->profile_img)){
                    $candidateOfferedJob[$offeredDataKey]['profile_image'] = DISPLAY_FULL_PROFILE_IMAGE_PATH . $value->profile_img;
                }else{
                    $candidateOfferedJob[$offeredDataKey]['profile_image'] = "";
                }
            
                if ($value->gender == 1) {
                    $candidateOfferedJob[$offeredDataKey]['gender'] = 'Male';
                } else if ($value->gender == 2) {
                    $candidateOfferedJob[$offeredDataKey]['gender'] = 'Female';
                } else {
                    $candidateOfferedJob[$offeredDataKey]['gender'] = 'Other';
                }
            
                if ($value->martial_status == 1) {
                    $candidateOfferedJob[$offeredDataKey]['martial_status'] = "Single";
                } else if ($value->martial_status == 2) {
                    $candidateOfferedJob[$offeredDataKey]['martial_status'] = "Married";
                } else if ($value->martial_status == 3) {
                    $candidateOfferedJob[$offeredDataKey]['martial_status'] = "Divorced";
                } else {
                    $candidateOfferedJob[$offeredDataKey]['martial_status'] = "N/A";
                }
            
                if ($value->physically_challenged == 1) {
                    $candidateOfferedJob[$offeredDataKey]['physically_challenged'] = "Yes";
                } else if ($value->physically_challenged == 2) {
                    $candidateOfferedJob[$offeredDataKey]['physically_challenged'] = "No";
                } else if ($value->physically_challenged == 3) {
                    $candidateOfferedJob[$offeredDataKey]['physically_challenged'] = "Prefer not to say";
                } else {
                    $candidateOfferedJob[$offeredDataKey]['physically_challenged'] = "N/A";
                }
                
                if(!empty($value->document_cv)){
                    $candidateOfferedJob[$offeredDataKey]['cv_document'] = DISPLAY_RESUME_PATH.$value->document_cv;
                } else{
                    $candidateOfferedJob[$offeredDataKey]['cv_document'] = "";
                }
            
                $candidateOfferedJob[$offeredDataKey]['address'] = $value->address;
                
                $candidateOfferedJob[$offeredDataKey]['cover_letter_title'] = $value->cover_letter_title ?? "N/A";
                $candidateOfferedJob[$offeredDataKey]['cover_letter_description'] = $value->cover_letter_description ?? "N/A";
                
            
                $educations = CandidateEducation::where('candidate_job_apply_id', $value->id)->get();
                $educationData = [];
                foreach ($educations as $eduKey => $education) {
                    $educationData[$eduKey]['id'] = $education->id;
                    $educationData[$eduKey]['qualification_id'] = Qualification::find($education->qualification_id)->qualification_name;
                    $educationData[$eduKey]['course'] = $education->course;
                    $educationData[$eduKey]['school_college'] = $education->school_college;
                    $educationData[$eduKey]['city'] = $education->city;
                    $educationData[$eduKey]['university_board'] = $education->university_board;
                    $educationData[$eduKey]['passing_year'] = $education->passing_year;
                }
            
                $candidateOfferedJob[$offeredDataKey]['education'] = $educationData;
            
                $experience = CandidateExperience::where('candidate_job_apply_id', $value->id)->get();
                $experienceData = [];
                foreach ($experience as $expKey => $exp) {
                    $experienceData[$expKey]['id'] = $exp->id;
                    $experienceData[$expKey]['organisation_name'] = $exp->organisation_name;
                    
                    $designationName = Skill::where('type', 'Designation')->where('id', $exp->designation)->value('skill_name');
                    if(!empty($designationName)){
                        $experienceData[$expKey]['designation'] = $designationName;
                    } else{
                        $experienceData[$expKey]['designation'] = $exp->designation;
                    }
                    
                    $experienceData[$expKey]['reason_of_leaving'] = $exp->reason_of_leaving;
                    $experienceData[$expKey]['start_date'] = date('d M Y',strtotime($exp->start_date));
                    $experienceData[$expKey]['end_date'] = date('d M Y',strtotime($exp->end_date));
                }
            
                $candidateOfferedJob[$offeredDataKey]['experience'] = $experienceData;
            }
            
            
            $candidatesAcceptedJobOfferData = SelectedCandidate::where('employer_id', $currentUser)->where('offer_letter_accepted', 1)->get();
            // return Response(['response' => $candidatesAcceptedJobOfferData, 'status' =>200], 200);
            // exit();

            $candidatesAcceptedJobOffer = [];
            foreach ($candidatesAcceptedJobOfferData as $value) {
                
                $candidate = CandidateJobApply::where('id', $value->candidate_id)->first();
                
                if (is_null($candidate)) {
                    continue;
                }
                
                
                $designationId = Job::find($candidate->job_form_id)->designation;
                
                $designationName = Skill::where('type', 'Designation')->where('id', $designationId)->value('skill_name');
                if(!empty($designationName)){
                    $DesignationName = $designationName;
                } else{
                    $DesignationName = $designationId;
                }
                
            
                $candidateData = [
                    'candidate_id' => $candidate->id,
                    'first_name' => $candidate->first_name,
                    'middle_name' => $candidate->middle_name,
                    'last_name' => $candidate->last_name,
                    'email' => $candidate->email,
                    'contact_number' => $candidate->contact_number,
                    'date_of_birth' => date('d M Y', strtotime($candidate->date_of_birth)),
                    'gender' => $candidate->gender == 1 ? 'Male' : ($candidate->gender == 2 ? 'Female' : 'Other'),
                    'martial_status' => $candidate->martial_status == 1 ? 'Single' : ($candidate->martial_status == 2 ? 'Married' : ($candidate->martial_status == 3 ? 'Divorced' : 'N/A')),
                    'physically_challenged' => $candidate->physically_challenged == 1 ? 'Yes' : ($candidate->physically_challenged == 2 ? 'No' : ($candidate->physically_challenged == 3 ? 'Prefer not to say' : 'N/A')),
                    'address' => $candidate->address,
                    'job_id' => $candidate->job_form_id,
                    'job_name' => Job::find($candidate->job_form_id)->title,
                    'designation' => $DesignationName,
                ];
            
                // Fetch Education Details
                $educations = CandidateEducation::where('candidate_job_apply_id', $value->candidate_id)->get();
                $educationData = [];
                foreach ($educations as $education) {
                    $educationData[] = [
                        'id' => $education->id,
                        'qualification_id' => Qualification::find($education->qualification_id)->qualification_name,
                        'course' => $education->course,
                        'school_college' => $education->school_college,
                        'city' => $education->city,
                        'university_board' => $education->university_board,
                        'passing_year' => $education->passing_year
                    ];
                }
                $candidateData['education'] = $educationData;
            
                // Fetch Experience Details
                $experience = CandidateExperience::where('candidate_job_apply_id', $value->candidate_id)->get();
                $experienceData = [];
                foreach ($experience as $exp) {
                    $experienceData[] = [
                        'id' => $exp->id,
                        'organisation_name' => $exp->organisation_name,
                        'designation' => $exp->designation,
                        'reason_of_leaving' => $exp->reason_of_leaving,
                        'start_date' => date('d M Y', strtotime($exp->start_date)),
                        'end_date' => date('d M Y', strtotime($exp->end_date))
                    ];
                }
                $candidateData['experience'] = $experienceData;
            
                // Append to the main array without overwriting keys
                $candidatesAcceptedJobOffer[] = $candidateData;
            }

            
            $notifications = Notification::where('user_id', $currentUser)->where('user_type', 'employer')->get();
            
            $notificationData = [];
            foreach($notifications as $notificationKey => $value){
                $notificationData[$notificationKey]['id'] = $value->id;
                $notificationData[$notificationKey]['user_id'] = $value->user_id;
                $notificationData[$notificationKey]['user_type'] = $value->user_type;
                $notificationData[$notificationKey]['notification_title'] = $value->notification_title;
                $notificationData[$notificationKey]['notification_text'] = $value->notification_text;
                $notificationData[$notificationKey]['mark_as_read'] = $value->mark_as_read;
                $notificationData[$notificationKey]['created_at'] = format_date($value->created_at);
            }
            
            
            $currentYear = Carbon::now()->year;
            
            $totalJobs = DB::table('jobs')
                            ->selectRaw('MONTHNAME(created_at) as month, COUNT(*) as jobs')
                            ->whereYear('created_at', $currentYear)
                            ->where('employer_id', $currentUser) // Apply employer_id filter
                            ->groupBy('month')
                            ->get()
                            ->keyBy('month')
                            ->toArray();

                            
            
                            
            $totalCandidates = DB::table('candidate_job_applies')
                                    ->selectRaw('MONTHNAME(created_at) as month, COUNT(*) as candidates') // Replace 'selected' with actual column
                                    ->whereYear('created_at', $currentYear)
                                    ->where('employer_id', $currentUser) // Apply employer_id filter
                                    ->groupBy('month')
                                    ->get()
                                    ->keyBy('month')
                                    ->toArray();
                                    
            $totalSelectedCandidates = DB::table('selected_candidates')
                                            ->selectRaw('MONTHNAME(created_at) as month, COUNT(*) as selectedCandidates')
                                            ->whereYear('created_at', $currentYear)
                                            ->where('employer_id', $currentUser) // Apply employer_id filter
                                            ->groupBy('month')
                                            ->get()
                                            ->keyBy('month')
                                            ->toArray();
                                            
                                            
            $dashboardData = [];
            $monthsOrder = ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'];
            
            foreach ($monthsOrder as $month) {
                $dashboardData[$month] = [
                    'candidates' => $totalCandidates[$month]->candidates ?? 0,
                    'jobs' => $totalJobs[$month]->jobs ?? 0,
                    'selectedCandidates' => $totalSelectedCandidates[$month]->selectedCandidates ?? 0,
                ];
            }
            
            $dashboardChartData = [];
            foreach ($dashboardData as $month => $data) {
                $dashboardChartData[$month] = [
                    $data['candidates'],
                    $data['jobs'],
                    $data['selectedCandidates']
                ];
            }
                                            

            
            return Response(['response' => ['dashboardChartData' => $dashboardChartData, 'latestApplications' => $latestApplicationData, 'activeJobs' => $activeJobsData, 'upcomingInterview' => $upcomingInterviewData, 'candidateOfferedJob' => $candidateOfferedJob, 'candidatesAcceptedJobOffer' => $candidatesAcceptedJobOffer, 'notificationData' => $notificationData], 'status' => 200], 200);

        }
        
        // Check for staff
        if(!empty($StaffCheck)){
            $latestApplications = CandidateJobApply::orderBy('created_at', 'desc')->take(100)->get();
    
            $latestApplicationData = array();
        
            foreach ($latestApplications as $key => $value) {
                $latestApplicationData[$key]['id'] = $value->id;
                $latestApplicationData[$key]['job_form_id'] = $value->job_form_id;
                
                $latestApplicationData[$key]['first_name'] = $value->first_name;
                
                if(!empty($value->middle_name)){
                    $latestApplicationData[$key]['middle_name'] = $value->middle_name;
                } else{
                    $latestApplicationData[$key]['middle_name'] = "N/A";
                }
                
                $latestApplicationData[$key]['last_name'] = $value->last_name;
                
                $latestApplicationData[$key]['name'] = $value->first_name . ' ' . $value->middle_name . ' ' . $value->last_name;
                $latestApplicationData[$key]['phone'] = $value->contact_number;
                
                if(!empty($value->document_cv)){
                    $latestApplicationData[$key]['cv_document'] = DISPLAY_RESUME_PATH.$value->document_cv;
                } else{
                    $latestApplicationData[$key]['cv_document'] = "";
                }
                                
                $latestApplicationData[$key]['email'] = $value->email;
                $latestApplicationData[$key]['cover_letter_title'] = $value->cover_letter_title ?? "N/A";
                $latestApplicationData[$key]['cover_letter_description'] = $value->cover_letter_description ?? "N/A";
                
                
                if($value->gender == 1){
                    $latestApplicationData[$key]['gender'] = 'Male';
                } else if($value->gender == 2){
                    $latestApplicationData[$key]['gender'] = 'Female';
                }else{
                    $latestApplicationData[$key]['gender'] = 'Other';
                }
                
                if(!empty($value->profile_img)){
                    $latestApplicationData[$key]['profile_image'] = DISPLAY_FULL_PROFILE_IMAGE_PATH.$value->profile_img;
                }else{
                    $latestApplicationData[$key]['profile_image'] = "";
                }
                
                if(!empty($value->document_cv)){
                    $latestApplicationData[$key]['document_cv'] = DISPLAY_RESUME_PATH.$value->document_cv;
                } else{
                    $latestApplicationData[$key]['document_cv'] = "";
                }
                
                $latestApplicationData[$key]['email_address'] = $value->email;
                $latestApplicationData[$key]['contact'] = $value->contact_number;
                $latestApplicationData[$key]['date_of_birth'] = date('d M Y',strtotime($value->date_of_birth));
                
                if($value->martial_status == 1){
                        $latestApplicationData[$key]['martial_status'] = "Single";
                    } else if($value->martial_status == 2){
                        $latestApplicationData[$key]['martial_status'] = "Married";
                    } else if($value->martial_status == 3){
                        $latestApplicationData[$key]['martial_status'] = "Divorced";
                    }else{
                        $latestApplicationData[$key]['martial_status'] = "N/A";
                    }
                    
                    if($value->physically_challenged == 1){
                        $latestApplicationData[$key]['physically_challenged'] = "Yes";
                    } else if($value->physically_challenged == 2){
                        $latestApplicationData[$key]['physically_challenged'] = "No";
                    } else if($value->physically_challenged == 3){
                        $latestApplicationData[$key]['physically_challenged'] = "Prefer not to say";
                    }else{
                        $latestApplicationData[$key]['physically_challenged'] = "N/A";
                    }
                
                if(!empty($value->address)){
                    $latestApplicationData[$key]['address'] = $value->address;
                } else{
                    $latestApplicationData[$key]['address'] = "N/A";
                }
                
                
        
                // Fetch the job title
                $job = Job::find($value->job_form_id);
                if ($job) {
                    $latestApplicationData[$key]['job_name'] = $job->title;
                    $latestApplicationData[$key]['slug'] = $job->slug;
                } else {
                    $latestApplicationData[$key]['job_name'] = 'Job Not Available';
                    $latestApplicationData[$key]['slug'] = null; // Or handle appropriately
                }
        
                $educations = CandidateEducation::where('candidate_job_apply_id', $value->id)->get();
                
                $educationData = array();
                foreach ($educations as $eduKey => $education) {
                    $educationData[$eduKey]['id'] = $education->id;
                    // $educationData[$eduKey]['qualification_id'] = Qualification::find($education->qualification_id)->qualification_name;
                    
                    $qualificationName = Qualification::where('id', $education->qualification_id)->value('qualification_name');
                    if(!empty($qualificationName)){
                        $educationData[$eduKey]['qualification_id'] = $qualificationName;
                    } else{
                        $educationData[$eduKey]['qualification_id'] = $education->designation;
                    }
                    
                    $educationData[$eduKey]['course'] = $education->course;
                    $educationData[$eduKey]['school_college'] = $education->school_college;
                    $educationData[$eduKey]['city'] = $education->city;
                    $educationData[$eduKey]['university_board'] = $education->university_board;
                    $educationData[$eduKey]['passing_year'] = $education->passing_year;
                }
                $latestApplicationData[$key]['education'] = $educationData;
        
                $experience = CandidateExperience::where('candidate_job_apply_id', $value->id)->get();
                $experienceData = array();
                foreach ($experience as $expKey => $exp) {
                    $experienceData[$expKey]['id'] = $exp->id;
                    $experienceData[$expKey]['organisation_name'] = $exp->organisation_name;
                    $experienceData[$expKey]['designation'] = $exp->designation;
                    $experienceData[$expKey]['reason_of_leaving'] = $exp->reason_of_leaving;
                    $experienceData[$expKey]['start_date'] = date('d M Y',strtotime($exp->start_date));
                    $experienceData[$expKey]['end_date'] = date('d M Y',strtotime($exp->end_date));
                }
                $latestApplicationData[$key]['experience'] = $experienceData;
                $latestApplicationData[$key]['created_at'] = format_date($value->created_at);
            }
        
            $activeJobs = Job::where('job_status', 1)->orderBy('created_at', 'desc')->take(10)->get();
            $activeJobsData = array();
            foreach ($activeJobs as $activeJobKey => $value) {
                $activeJobsData[$activeJobKey]['id'] = $value->id;
                $activeJobsData[$activeJobKey]['job_name'] = $value->title;
                $activeJobsData[$activeJobKey]['min_exp'] = $value->min_exp;
                $activeJobsData[$activeJobKey]['max_exp'] = $value->max_exp;
                $activeJobsData[$activeJobKey]['created_at'] = format_date($value->created_at);
                $activeJobsData[$activeJobKey]['slug'] = $value->slug;
            }
            
            // Jobs created by staff
            $jobsCreated = Job::where('staff_id', $currentUser)->orderBy('created_at', 'desc')->take(10)->get();
            $jobsCreatedData = array();
            foreach ($jobsCreated as $JobKey => $value) {
                $jobsCreatedData[$JobKey]['id'] = $value->id;
                $jobsCreatedData[$JobKey]['job_name'] = $value->title;
                $jobsCreatedData[$JobKey]['min_exp'] = $value->min_exp;
                $jobsCreatedData[$JobKey]['max_exp'] = $value->max_exp;
                $jobsCreatedData[$JobKey]['created_at'] = format_date($value->created_at);
                $jobsCreatedData[$JobKey]['slug'] = $value->slug;
            }
        
            // $interviewsAssigned = CandidateInterviewResponse::where('interviewer_id',$currentUser)->orderBy('created_at', 'desc')->take(10)->get();
            // $interviewAssignedData = array();
            // foreach ($interviewsAssigned as $interviewKey => $value) {
            //     $interviewAssignedData[$interviewKey]['id'] = $value->id;
            
            //     // Fetch the candidate's first and last name
            //     $candidate = CandidateJobApply::where('id', $value->candidate_id)->select('first_name', 'last_name')->first();
            //     $interviewAssignedData[$interviewKey]['candidate_name'] = $candidate ? $candidate->first_name . ' ' . $candidate->last_name : '';
            
            //     // Fetch the interviewer's first and last name
            //     $interviewer = Staff::where('id', $value->interviewer_id)->select('first_name', 'last_name')->first();
            //     $interviewAssignedData[$interviewKey]['interviewer_name'] = $interviewer ? $interviewer->first_name . ' ' . $interviewer->last_name : '';
            //     $interviewAssignedData[$interviewKey]['job_id'] = $value->job_id;
            //     $interviewAssignedData[$interviewKey]['interview_date'] = $value->interview_date ? Carbon::parse($value->interview_date)->toDateString() : "Interview not scheduled";
            //     $interviewAssignedData[$interviewKey]['created_at'] = format_date($value->created_at);
            //     $interviewAssignedData[$interviewKey]['start_time'] = $value->start_time;
                
                
            //     $educations = CandidateEducation::where('candidate_job_apply_id', $value->candidate_id)->get();
                
            //     $educationData = array();
            //     foreach ($educations as $eduKey => $education) {
            //         $educationData[$eduKey]['id'] = $education->id;
            //         $educationData[$eduKey]['qualification_id'] = Qualification::find($education->qualification_id)->qualification_name;
            //         $educationData[$eduKey]['course'] = $education->course;
            //         $educationData[$eduKey]['school_college_city'] = $education->school_college_city;
            //         $educationData[$eduKey]['university_board'] = $education->university_board;
            //         $educationData[$eduKey]['passing_year'] = $education->passing_year;
            //     }
                
            //     $interviewAssignedData[$interviewKey]['education'] = $educationData;
    
            //     $experience = CandidateExperience::where('candidate_job_apply_id', $value->candidate_id)->get();
            //     $experienceData = array();
            //     foreach ($experience as $expKey => $exp) {
            //         $experienceData[$expKey]['id'] = $exp->id;
            //         $experienceData[$expKey]['organisation_name'] = $exp->organisation_name;
            //         $experienceData[$expKey]['designation'] = $exp->designation;
            //         $experienceData[$expKey]['reason_of_leaving'] = $exp->reason_of_leaving;
            //         $experienceData[$expKey]['start_date'] = $exp->start_date;
            //         $experienceData[$expKey]['end_date'] = $exp->end_date;
            //     }
                
            //     $interviewAssignedData[$interviewKey]['experience'] = $experienceData;
           
               
            // }
            
            $upcomingInterview = CandidateInterviewSchedule::whereMonth('created_at', now()->month)
                                ->whereYear('created_at', now()->year)
                                ->orderBy('created_at', 'desc')
                                ->take(5)
                                ->get();
            
            // return Response(['response' => $upcomingInterview, 'message' => 'done', 'status' => 200], 200);

            $upcomingInterviewData = array();
            foreach ($upcomingInterview as $interviewKey => $value) {
                $upcomingInterviewData[$interviewKey]['id'] = $value->id;
            
                // Fetch the candidate's first and last name
                $candidate = CandidateJobApply::where('id', $value->candidate_id)->first();
                // return Response(['response' => $candidate, 'message' => '', 'status' => 200], 200);
                // exit();
                $upcomingInterviewData[$interviewKey]['candidate_name'] = $candidate ? $candidate->first_name . ' ' . $candidate->last_name : '';
                
                
                // $upcomingInterviewData[$interviewKey]['contact_number'] = $candidate ? $candidate->contact_number : 'N/A';
                // $upcomingInterviewData[$interviewKey]['date_of_birth'] = date('d M Y',strtotime($candidate->date_of_birth));
                
                // if($candidate->gender == 1){
                //     $upcomingInterviewData[$interviewKey]['gender'] = 'Male';
                // } else if($candidate->gender == 2){
                //     $upcomingInterviewData[$interviewKey]['gender'] = 'Female';
                // }else{
                //     $upcomingInterviewData[$interviewKey]['gender'] = 'Other';
                // }
                
                // if($candidate->martial_status == 1){
                //         $upcomingInterviewData[$interviewKey]['martial_status'] = "Single";
                //     } else if($candidate->martial_status == 2){
                //         $upcomingInterviewData[$interviewKey]['martial_status'] = "Married";
                //     } else if($candidate->martial_status == 3){
                //         $upcomingInterviewData[$interviewKey]['martial_status'] = "Divorced";
                //     }else{
                //         $upcomingInterviewData[$interviewKey]['martial_status'] = "N/A";
                //     }
                    
                //     if($candidate->physically_challenged == 1){
                //         $upcomingInterviewData[$interviewKey]['physically_challenged'] = "Yes";
                //     } else if($candidate->physically_challenged == 2){
                //         $upcomingInterviewData[$interviewKey]['physically_challenged'] = "No";
                //     } else if($candidate->physically_challenged == 3){
                //         $upcomingInterviewData[$interviewKey]['physically_challenged'] = "Prefer not to say";
                //     }else{
                //         $upcomingInterviewData[$interviewKey]['physically_challenged'] = "N/A";
                //     }
                
                
                // if(!empty($candidate->profile_img)){
                //     $upcomingInterviewData[$interviewKey]['profile_image'] = DISPLAY_FULL_PROFILE_IMAGE_PATH.$candidate->profile_img;
                // }else{
                //     $upcomingInterviewData[$interviewKey]['profile_image'] = "";
                // }
                
                // if(!empty($candidate->document_cv)){
                //     $upcomingInterviewData[$interviewKey]['document_cv'] = DISPLAY_RESUME_PATH.$candidate->document_cv;
                // } else{
                //     $upcomingInterviewData[$interviewKey]['document_cv'] = "";
                // }
                
                
                // $upcomingInterviewData[$interviewKey]['address'] = $candidate->address;
                // $upcomingInterviewData[$interviewKey]['applied_date'] = $candidate->created_at->format('d-m-Y');
                
                $upcomingInterviewData[$interviewKey]['candidate_id'] = $value->candidate_id;
                // Fetch the interviewer's first and last name
                $interviewer = Staff::where('id', $value->assigned_to)->select('first_name', 'last_name')->first();
                $employer = Employer::where('id', $value->assigned_by)->select('first_name', 'last_name')->first();
                $process = Process::where('id', $value->process_id)->value('process_name');
                $upcomingInterviewData[$interviewKey]['interviewer_name'] = $interviewer ? $interviewer->first_name . ' ' . $interviewer->last_name : '';
                $upcomingInterviewData[$interviewKey]['interviewer_id'] = $value->assigned_to;
                $upcomingInterviewData[$interviewKey]['employer_id'] = $value->assigned_by;
                $upcomingInterviewData[$interviewKey]['employer_name'] = $employer ? $employer->first_name . ' ' . $employer->last_name : '';
                $upcomingInterviewData[$interviewKey]['job_id'] = $value->job_id;
                $jobName = Job::where('id', $value->job_id)->value('title');
                $upcomingInterviewData[$interviewKey]['job_name'] = $jobName;
                $upcomingInterviewData[$interviewKey]['process_id'] = $value->process_id;
                $upcomingInterviewData[$interviewKey]['process_name'] = $process;
                $upcomingInterviewData[$interviewKey]['interview_date'] = $value->interview_date ? Carbon::parse($value->interview_date)->toDateString() : "Interview not scheduled";
                $upcomingInterviewData[$interviewKey]['created_at'] = format_date($value->created_at);
                $upcomingInterviewData[$interviewKey]['start_time'] = $value->start_time;
                
                
                $educations = CandidateEducation::where('candidate_job_apply_id', $value->candidate_id)->get();
                
                $educationData = array();
                foreach ($educations as $eduKey => $education) {
                    $educationData[$eduKey]['id'] = $education->id;
                    $educationData[$eduKey]['qualification_id'] = Qualification::find($education->qualification_id)->qualification_name;
                    $educationData[$eduKey]['course'] = $education->course;
                    $educationData[$eduKey]['school_college'] = $education->school_college;
                    $educationData[$eduKey]['city'] = $education->city;
                    $educationData[$eduKey]['university_board'] = $education->university_board;
                    $educationData[$eduKey]['passing_year'] = $education->passing_year;
                }
                
                $upcomingInterviewData[$interviewKey]['education'] = $educationData;
    
                $experience = CandidateExperience::where('candidate_job_apply_id', $value->candidate_id)->get();
                $experienceData = array();
                foreach ($experience as $expKey => $exp) {
                    $experienceData[$expKey]['id'] = $exp->id;
                    $experienceData[$expKey]['organisation_name'] = $exp->organisation_name;
                    $experienceData[$expKey]['designation'] = $exp->designation;
                    $experienceData[$expKey]['reason_of_leaving'] = $exp->reason_of_leaving;
                    $experienceData[$expKey]['start_date'] = date('d M Y',strtotime($exp->start_date));
                    $experienceData[$expKey]['end_date'] = date('d M Y',strtotime($exp->end_date));
                }
                
                $upcomingInterviewData[$interviewKey]['experience'] = $experienceData;
            }
            
            $activeJobs = Job::where('staff_id', $currentUser)->where('job_status', 1)->orderBy('created_at', 'desc')->take(5)->get();
            $activeJobsData = array();
            foreach ($activeJobs as $activeJobKey => $value) {
                $activeJobsData[$activeJobKey]['id'] = $value->id;
                $activeJobsData[$activeJobKey]['job_name'] = $value->title;
                $activeJobsData[$activeJobKey]['min_exp'] = $value->min_exp;
                $activeJobsData[$activeJobKey]['max_exp'] = $value->max_exp;
                $activeJobsData[$activeJobKey]['created_at'] = format_date($value->created_at);
                $activeJobsData[$activeJobKey]['slug'] = $value->slug;
            }
            
            
            $notifications = Notification::where('user_id', $currentUser)->where('user_type', 'staff')->get();
            
            $notificationData = [];
            foreach($notifications as $notificationKey => $value){
                $notificationData[$notificationKey]['id'] = $value->id;
                $notificationData[$notificationKey]['user_id'] = $value->user_id;
                $notificationData[$notificationKey]['user_type'] = $value->user_type;
                $notificationData[$notificationKey]['notification_title'] = $value->notification_title;
                $notificationData[$notificationKey]['notification_text'] = $value->notification_text;
                $notificationData[$notificationKey]['mark_as_read'] = $value->mark_as_read;
                $notificationData[$notificationKey]['created_at'] = format_date($value->created_at);
            }
            
            
            
            $currentYear = Carbon::now()->year;
            
                            
            $totalCandidates = DB::table('candidate_job_applies')
                                    ->selectRaw('MONTHNAME(created_at) as month, COUNT(*) as candidates') // Replace 'selected' with actual column
                                    ->whereYear('created_at', $currentYear)
                                    ->groupBy('month')
                                    ->get()
                                    ->keyBy('month')
                                    ->toArray();
                                    
            $totalInterviewAssigned = DB::table('candidate_interview_schedules')
                                            ->selectRaw('MONTHNAME(created_at) as month, COUNT(*) as total_interviews')
                                            ->whereYear('created_at', $currentYear)
                                            ->whereJsonContains('assigned_to', (string) $currentUser) // Ensure $currentUser is cast as a string if needed
                                            ->groupBy('month')
                                            ->get()
                                            ->keyBy('month')
                                            ->toArray();


                                            
                                            
            $dashboardData = [];
            $monthsOrder = ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'];
            
            foreach ($monthsOrder as $month) {
                $dashboardData[$month] = [
                    'candidates' => $totalCandidates[$month]->candidates ?? 0,
                    'total_interviews' => $totalInterviewAssigned[$month]->total_interviews ?? 0
                ];
            }
            
            $dashboardChartData = [];
            foreach ($dashboardData as $month => $data) {
                $dashboardChartData[$month] = [
                    $data['candidates'],
                    $data['total_interviews']
                ];
            }
            
            
            
            return Response(['response' => ['latestApplications' => $latestApplicationData, 'jobsCreated' => $jobsCreatedData, 'upcomingInterview' => $upcomingInterviewData, 'activeJobsData' => $activeJobsData, 'dashboardChartData' => $dashboardChartData, 'notificationData' => $notificationData], 'status' => 200], 200);

        }
        
    }

}
