<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\Admin;
use App\Models\CandidateJobApply;
use App\Models\StatusAttributes;
use Illuminate\Http\Request;
use App\Models\Process;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use App\Models\CandidateFeedback;
use App\Models\Staff;
use App\Models\Job;
use App\Models\Employer;
use App\Models\OfferDraftData;
use App\Models\CandidateInterviewJourney;
use App\Models\CandidateInterviewStatus;
use App\Models\CandidateInterviewSchedule;
use App\Models\CandidateEducation;
use App\Models\CandidateExperience;
use App\Models\Qualification;
use App\Models\Skill;
use App\Models\SelectedCandidate;
use Carbon\Carbon;
use Mail;
use App\Models\EmailTemplate;
use App\Mail\SendMail;

class CandidatesController extends Controller
{
    //
    public function listing(Request $request) {
        
        $currentUser = Auth::user()->id;
        $adminCheck = Admin::where('id', $currentUser)->first();
        $employerCheck = Employer::where('id', $currentUser)->first();
        $staffCheck = Staff::where('id', $currentUser)->first();
        
        if (!empty($adminCheck)) {
            $candidates = CandidateJobApply::all();
            $candidateData = array();

            foreach($candidates as $key => $value) {
                
                $employerName = Employer::where('id', $value->employer_id)
                    ->selectRaw("CONCAT(first_name, ' ', last_name) as full_name")
                    ->first();
                $staffName = Staff::where('id', $value->staff_id)
                    ->selectRaw("CONCAT(first_name, ' ', last_name) as full_name")
                    ->first();

                $candidateData[$key]['candidate_id'] = $value->id;
                $candidateData[$key]['job_id'] = $value->job_form_id;
                $candidateData[$key]['first_name'] = $value->first_name;
                $candidateData[$key]['last_name'] = $value->last_name;
                $candidateData[$key]['email'] = $value->email;
                $candidateData[$key]['phone'] = $value->contact_number;
                $candidateData[$key]['address'] = $value->address;
                $candidateData[$key]['gender'] = $value->gender;
                $candidateData[$key]['dateofbirth'] = $value->date_of_birth;
                $candidateData[$key]['martialstatus'] = $value->martial_status;
                $candidateData[$key]['physical_challenged'] = $value->physical_challenge;
                $candidateData[$key]['created'] = format_date($value->created);
                $candidateData[$key]['status'] = $value->status;
                $candidateData[$key]['interview_status'] = $value->interview_status;
                $candidateData[$key]['interviewDetails'] = getFeedbackData($value->id);
                $candidateData[$key]['jobAppliedFor'] = Job::where('id',$value->job_form_id)->value('title');
            }
            
            $status = StatusAttributes::where('status', 1)->get();
        
            $data['candidatesData'] = $candidateData;
            $data['statusList'] = $status;
            
            
            $process = Process::where('status', 1)->get();
            $data['processList'] = $process;
    
            $user = Admin::where('id', '!=', 1)->get();
            $data['user'] = $user;
    
            return Response(['response' => $data], 200);
        } else if(!empty($employerCheck)) {
            $candidates = CandidateJobApply::where('employer_id', $currentUser)->orderBy('id', 'desc')->get();
            $candidateData = array();

            foreach($candidates as $key => $value) {
                
                $employerRecord = Employer::where('id', $value->employer_id)
                    ->selectRaw("CONCAT(first_name, ' ', last_name) as full_name")
                    ->first();
                if(!empty($employerRecord)){
                    $employerName = $employerRecord->full_name;
                }else {
                    $employerName = "Not Available";
                }
                $staffRecord = Staff::where('id', $value->staff_id)
                    ->selectRaw("CONCAT(first_name, ' ', last_name) as full_name")
                    ->first();
                    
                if(!empty($staffRecord)){
                    $staffName = $staffRecord->full_name;
                }else {
                    $staffName = "Not Available";
                }
                    
                
                $candidateData[$key]['candidate_id'] = $value->id;
                $candidateData[$key]['id'] = $value->id;
                $candidateData[$key]['job_id'] = $value->job_form_id;
                $candidateData[$key]['first_name'] = $value->first_name;
                $candidateData[$key]['middle_name'] = $value->middle_name;
                $candidateData[$key]['last_name'] = $value->last_name;
                    if($value->gender == 1){
                        $candidateData[$key]['gender'] = "Male";
                    } else if($value->gender == 2){
                        $candidateData[$key]['gender'] = "Female";
                    }else{
                        $candidateData[$key]['gender'] = "Other";
                    }
                    if(!empty($value->profile_img)){
                        $candidateData[$key]['profile_image'] = DISPLAY_FULL_PROFILE_IMAGE_PATH.$value->profile_img;
                    }else{
                        $candidateData[$key]['profile_image'] = "";
                    }
                    if(!empty($value->document_cv)){
                        $candidateData[$key]['cv_document'] = DISPLAY_RESUME_PATH.$value->document_cv;
                    }else{
                        $candidateData[$key]['cv_document'] = "";
                    }
                    $candidateData[$key]['email_address'] = $value->email;
                    $candidateData[$key]['contact'] = $value->contact_number;
                    $candidateData[$key]['date_of_birth'] = $value->date_of_birth;
                    if($value->martial_status == 1){
                        $candidateData[$key]['martial_status'] = "Single";
                    } else if($value->martial_status == 2){
                        $candidateData[$key]['martial_status'] = "Married";
                    } else if($value->martial_status == 3){
                        $candidateData[$key]['martial_status'] = "Divorced";
                    }else{
                        $candidateData[$key]['martial_status'] = "N/A";
                    }
                    if($value->physically_challenged == 1){
                        $candidateData[$key]['physically_challenged'] = "Yes";
                    } else if($value->physically_challenged == 2){
                        $candidateData[$key]['physically_challenged'] = "No";
                    } else if($value->physically_challenged == 3){
                        $candidateData[$key]['physically_challenged'] = "Prefer not to say";
                    }else{
                        $candidateData[$key]['physically_challenged'] = "N/A";
                    }
                    $candidateData[$key]['address'] = $value->address;
                    $candidateData[$key]['applied_date'] = $value->created_at->format('d-m-Y');
                    $candidateData[$key]['interview_status'] = $value->interview_status;
                
                $jobName = Job::where('id',$value->job_form_id)->value('title');
                if(!empty($jobName)){
                    $candidateData[$key]['jobAppliedFor'] = $jobName;
                } else{
                    $candidateData[$key]['jobAppliedFor'] = "Job not available";
                }
                
                $education = CandidateEducation::where('candidate_job_apply_id', $value->id)->get();
                    $educationData = array();
                    foreach ($education as $eduKey => $eduValue) {
                        $educationData[$eduKey]['id'] = $eduValue->id;
                        $educationData[$eduKey]['qualification_id'] = Qualification::find($eduValue->qualification_id)->qualification_name;
                        $educationData[$eduKey]['course'] = $eduValue->course;
                        $educationData[$eduKey]['school_college'] = $eduValue->school_college;
                        $educationData[$eduKey]['city'] = $eduValue->city;
                        $educationData[$eduKey]['university_board'] = $eduValue->university_board;
                        $educationData[$eduKey]['passing_year'] = $eduValue->passing_year;
                    }
                    $candidateData[$key]['education'] = $educationData;
        
                    $experience = CandidateExperience::where('candidate_job_apply_id', $value->id)->get();
                    $experienceData = array();
                    foreach ($experience as $expKey => $expValue) {
                        $experienceData[$expKey]['id'] = $expValue->id;
                        $experienceData[$expKey]['organisation_name'] = $expValue->organisation_name;
                        
                        $designationName = Skill::where('type', 'Designation')->where('id', $expValue->designation)->value('skill_name');
                        if(!empty($designationName)){
                            $experienceData[$expKey]['designation'] = $designationName;
                        } else{
                            $experienceData[$expKey]['designation'] = $expValue->designation;
                        }
                        
                        // $experienceData[$expKey]['designation'] = $expValue->designation;
                        $experienceData[$expKey]['reason_of_leaving'] = $expValue->reason_of_leaving;
                        $experienceData[$expKey]['start_date'] = $expValue->start_date;
                        $experienceData[$expKey]['end_date'] = $expValue->end_date;
                    }
                    $candidateData[$key]['experience'] = $experienceData;
                
            }
            
            // $status = StatusAttributes::where('status', 1)->get();
            
            $status = StatusAttributes::where(function ($query) use ($employerCheck) {
                $query->where('employer_id', $employerCheck->id)
                    ->orWhere('employer_id', 0);
            })
                ->where('status', 1)
                // ->orderBy('id', 'desc')
                ->get();
        
            $data['candidatesData'] = $candidateData;
            $data['statusList'] = $status;
            
            
            $process = Process::where('employer_id', $currentUser)->orWhere('employer_id','0')->get();
            $data['processList'] = $process;
    
            $user = Staff::where('employer_id', $currentUser)->get();
            $data['user'] = $user;
    
            return Response(['response' => $data], 200);
            
        } else if(!empty($staffCheck)){
            $candidates = CandidateJobApply::where('staff_id', $currentUser)->get();
            $candidateData = array();

            foreach($candidates as $key => $value) {
                
                
            $candidateData[$key]['candidate_id'] = $value->id;
            $candidateData[$key]['job_id'] = $value->job_form_id;
            $candidateData[$key]['employer_id'] = $value->employer_id;
            $candidateData[$key]['staff_id'] = $value->staff_id;
            $candidateData[$key]['first_name'] = $value->first_name;
            $candidateData[$key]['last_name'] = $value->last_name;
            $candidateData[$key]['email'] = $value->email;
            $candidateData[$key]['phone'] = $value->contact_number;
            $candidateData[$key]['address'] = $value->address;
            $candidateData[$key]['gender'] = $value->gender;
            $candidateData[$key]['dateofbirth'] = $value->date_of_birth;
            $candidateData[$key]['martialstatus'] = $value->martial_status;
            $candidateData[$key]['physical_challenged'] = $value->physical_challenge;
            $candidateData[$key]['created'] = format_date($value->created);
            $candidateData[$key]['status'] = $value->status;
            $candidateData[$key]['interview_status'] = $value->interview_status;
            $candidateData[$key]['interviewDetails'] = getFeedbackData($value->id);
            $candidateData[$key]['jobAppliedFor'] = Job::where('id',$value->job_form_id)->value('title');

            }
    
            return Response(['response' => $candidateData], 200);
            
        }
        $candidateData = array();

        foreach($candidates as $key => $value) {
            
            $candidateData[$key]['candidate_id'] = $value->id;
             $candidateData[$key]['job_id'] = $value->job_form_id;
             $candidateData[$key]['employer_id'] = $value->employer_id;
             $candidateData[$key]['staff_id'] = $value->staff_id;
             $candidateData[$key]['first_name'] = $value->first_name;
            $candidateData[$key]['last_name'] = $value->last_name;
             $candidateData[$key]['email'] = $value->email;
             $candidateData[$key]['phone'] = $value->contact_number;
             $candidateData[$key]['address'] = $value->address;
            $candidateData[$key]['gender'] = $value->gender;
             $candidateData[$key]['dateofbirth'] = $value->date_of_birth;
             $candidateData[$key]['martialstatus'] = $value->martial_status;
             $candidateData[$key]['physical_challenged'] = $value->physical_challenge;
             $candidateData[$key]['created'] = format_date($value->created);
             $candidateData[$key]['status'] = $value->status;
             $candidateData[$key]['interview_status'] = $value->interview_status;
             $candidateData[$key]['interviewDetails'] = getFeedbackData($value->id);
        }

        return Response(['response' => $candidateData], 200);
        
    
}
    // public function candidateStatusChange(Request $request, $id) {
    //     $statusId = $request->status;
    //     // $employerId = Auth::user()->id();
    //     $candidateId = $request->candidate_id;
    //     $reason = $request->reason;
             
    //     if($statusId == "9"){
    //         // $companyName = Employer::where('id', $employerId)->value('company_name');
    //         $candidateData = CandidateJobApply::where('id', $candidateId)->select('first_name', 'last_name')->first();
    //         $candidateName = $candidateData ? $candidateData->first_name . ' ' . $candidateData->last_name : '';
    //         $candidateEmail = CandidateJobApply::where('id', $candidateId)->value('email');
    //         $jobId = CandidateJobApply::where('id', $candidateId)->value('job_form_id');
    //         $jobName = Job::where('id', $jobId)->value('title');
            
    //         $emailTemplate = EmailTemplate::where('id', 4)->first();
            
    //         $toRepArray = ['[!candidate_name!]', '[!job_name!]', '[!company_name!]', '[!reason!]'];
    //         $fromRepArray = [$candidateName, $jobName, 'Keshari', $request->reason];
                
                
    //         $emailSubject = str_replace($toRepArray, $fromRepArray, $emailTemplate->subject);
    //         $emailBody = str_replace($toRepArray, $fromRepArray, $emailTemplate->template);
                
                
    //         // Send the email
    //         try {
    //             Mail::to($candidateEmail)->send(new SendMail($emailBody, $emailSubject));
    //         } catch (\Exception $e) {
    //             return response()->json(['error' => 'Failed to send email.', 'message' => $e->getMessage()], 500);
    //         }
            
    //     }
        
        
    //     $candidate = CandidateJobApply::where('id', $id)->update(['interview_status' => $statusId]);

    //     return Response(['response' => $candidate,  'message' => 'Status updated', 'status' => 200], 200);

    // }
    
    
    public function candidateStatusChange(Request $request, $id)
{
    $statusId = $request->status;
    $candidateId = $request->candidate_id;
    $reason = $request->reason;
    $sendRejectionMessage = $request->sendRejectionMessage; 

    if ($statusId == "9") {
        // Retrieve candidate details
        $candidateData = CandidateJobApply::where('id', $candidateId)->select('first_name', 'last_name', 'email')->first();
        if (!$candidateData) {
            return response()->json(['error' => 'Candidate not found'], 404);
        }
        $candidateName = $candidateData->first_name . ' ' . $candidateData->last_name;
        $candidateEmail = $candidateData->email;

        // Retrieve job details
        $jobId = $candidateData->job_form_id;
        $jobName = Job::where('id', $jobId)->value('title');
        
        //employer id
        $employerId = $candidateData->employer_id;

        // Get the email template
        $emailTemplate = EmailTemplate::where('id', 4)->first();
        if (!$emailTemplate) {
            return response()->json(['error' => 'Email template not found'], 404);
        }
        
        if($sendRejectionMessage == 'true'){
            $updateReason = $reason;
        } else{
            $updateReason = '';
        }
        
        // Replace placeholders in the email template
        $toRepArray = ['[!candidate_name!]', '[!job_name!]', '[!company_name!]', '[!reason!]'];
        $fromRepArray = [$candidateName, $jobName, 'Keshari', $updateReason];

        $emailSubject = str_replace($toRepArray, $fromRepArray, $emailTemplate->subject);
        $emailBody = str_replace($toRepArray, $fromRepArray, $emailTemplate->template);
        
        $logo = Employer::where('id', $employerId)->value('company_logo');
                
                if(!empty($logo)){
                    $logoPath = EMPLOYER_COMPANY_LOGO_DISPLAY_PATH . $logo;
                } else{
                    $logoPath = LOGO_PATH;
                }

        // Send the email
        try {
            if (filter_var($candidateEmail, FILTER_VALIDATE_EMAIL)) {
                Mail::to($candidateEmail)->send(new SendMail($emailBody, $emailSubject, $logoPath));
            } else {
                return response()->json(['error' => 'Invalid email address'], 400);
            }
        } catch (\Exception $e) {
            return response()->json(['error' => 'Failed to send email.', 'message' => $e->getMessage()], 500);
        }
    }

    // Update the candidate status
    $candidate = CandidateJobApply::where('id', $id)->update(['interview_status' => $statusId]);

    return Response(['response' => $candidate,  'message' => 'Status updated', 'status' => 200], 200);
}

    
    public function candidateFeedback(Request $request) {

        // $uid = Auth::user()->id;
        // echo $uid;
        $validator = Validator::make($request->all(), [
            'candidate_id' => 'required',
            'feedback' => 'required',
        ]);
        $validator->setAttributeNames([
            'candidate_id' => 'Candidate ID',
            'feedback' => 'Feedback',
        ]);
        if($validator->fails()){
            return Response(['response' => $validator->errors(), 'status' => 500], 200);
        } else {
            $feedback = CandidateFeedback::insert([
                'user_id' => Auth::user()->id,
                'candidate_id' => $request->candidate_id,
                'feedback' => $request->feedback,
            ]);
            return Response(['response' => $feedback, 'message' => 'Feedback added successfully', 'status' => 200], 200);
        }
    }
    
    public function candidateInterviewSchedule(Request $request, $id) {
        
        if(!empty($request->all())){
            
        }else {
            $candidateData = CandidateJobApply::where('id', $id)->first();
            $processData = Process::where('status', 1)->get();
            $userList = Admin::where('id', '!=', 1)->get();

            return Response(['response' => ['candidateData' => $candidateData, 'processData' => $processData, 'userList' => $userList],  'message' => '', 'status' => 200], 200);
        }
    }
    
    public function candidateInterviewStatus(Request $request) {
        $candidateId = $request->candidate_id;
        $jobId = $request->job_id;
    
        $candidateInterviewJourneyDetails = DB::table('candidate_interview_journeys')
            ->where('job_id', $jobId)
            ->where('candidate_id', $candidateId)
            ->get();
    
        $candidateInterviewJourneyData = array();
    
        foreach($candidateInterviewJourneyDetails as $key => $value) {
            $candidateInterviewJourneyData[$key]['id'] = $value->id;
            $candidateInterviewJourneyData[$key]['candidate_id'] = $value->candidate_id;
            $candidateInterviewJourneyData[$key]['job_id'] = $value->job_id;
            $candidateInterviewJourneyData[$key]['process_id'] = $value->process_id;
    
            // Fetch the process name if process_id exists
            if($value->process_id) {
                $process = Process::where('id', $value->process_id)->select('process_name')->first();
                $candidateInterviewJourneyData[$key]['process_name'] = $process ? $process->process_name : "Name not available";
            } else {
                $candidateInterviewJourneyData[$key]['process_name'] = "Name not available";
            }
    
            $candidateInterviewJourneyData[$key]['order'] = $value->order_number;
            $candidateInterviewJourneyData[$key]['completion_status'] = $value->completion_status;
            $candidateInterviewJourneyData[$key]['created_at'] = $value->created_at;
        }
    
        return Response(['response' => $candidateInterviewJourneyData, 'status' => '200'], 200);
    }
    
    public function selectedCandidates(Request $request) {
        $currentUser = Auth::user()->id;
        $adminCheck = Admin::where('id', $currentUser)->first();
        $employerCheck = Employer::where('id', $currentUser)->first();
        $staffCheck = Staff::where('id', $currentUser)->first();
        
        if (!empty($adminCheck)) {
            $candidates = CandidateJobApply::all();
            $candidateData = array();

            foreach($candidates as $key => $value) {
                
                $employerName = Employer::where('id', $value->employer_id)
                    ->selectRaw("CONCAT(first_name, ' ', last_name) as full_name")
                    ->first();
                $staffName = Staff::where('id', $value->staff_id)
                    ->selectRaw("CONCAT(first_name, ' ', last_name) as full_name")
                    ->first();

                $candidateData[$key]['candidate_id'] = $value->id;
                $candidateData[$key]['job_id'] = $value->job_form_id;
                $candidateData[$key]['first_name'] = $value->first_name;
                $candidateData[$key]['last_name'] = $value->last_name;
                $candidateData[$key]['email'] = $value->email;
                $candidateData[$key]['phone'] = $value->contact_number;
                $candidateData[$key]['address'] = $value->address;
                $candidateData[$key]['gender'] = $value->gender;
                $candidateData[$key]['dateofbirth'] = $value->date_of_birth;
                $candidateData[$key]['martialstatus'] = $value->martial_status;
                $candidateData[$key]['physical_challenged'] = $value->physical_challenge;
                $candidateData[$key]['created'] = format_date($value->created);
                $candidateData[$key]['status'] = $value->status;
                $candidateData[$key]['interview_status'] = $value->interview_status;
                $candidateData[$key]['interviewDetails'] = getFeedbackData($value->id);
                $candidateData[$key]['jobAppliedFor'] = Job::where('id',$value->job_form_id)->value('title');
            }
            
            $status = StatusAttributes::where('status', 1)->get();
        
            $data['candidatesData'] = $candidateData;
            $data['statusList'] = $status;
            
            
            $process = Process::where('status', 1)->get();
            $data['processList'] = $process;
    
            $user = Admin::where('id', '!=', 1)->get();
            $data['user'] = $user;
    
            return Response(['response' => $data], 200);
        } else if(!empty($employerCheck)) {
            $candidates = CandidateJobApply::where('employer_id', $currentUser)->where('interview_status','8')->orderBy('id', 'desc')->get();
            $candidateData = array();
            
           
            
            // draft data 
            
            

            foreach($candidates as $key => $value) {
                
                $employerRecord = Employer::where('id', $value->employer_id)
                    ->selectRaw("CONCAT(first_name, ' ', last_name) as full_name")
                    ->first();
                if(!empty($employerRecord)){
                    $employerName = $employerRecord->full_name;
                }else {
                    $employerName = "Not Available";
                }
                $staffRecord = Staff::where('id', $value->staff_id)
                    ->selectRaw("CONCAT(first_name, ' ', last_name) as full_name")
                    ->first();
                    
                if(!empty($staffRecord)){
                    $staffName = $staffRecord->full_name;
                }else {
                    $staffName = "Not Available";
                }
                    
                
                $candidateData[$key]['candidate_id'] = $value->id;
                $candidateData[$key]['draft_status'] = $value->draft_status;
                if ($value->draft_status == "1") {
                    $candidateDraftData = OfferDraftData::where('candidate_id', $value->id)->first();
                    if(!empty($candidateDraftData)){
                        $candidateData[$key]['draft_data'] = $candidateDraftData;
                    }else{
                        $candidateData[$key]['draft_data'] = "";
                    }
                }else{
                    $candidateData[$key]['draft_data'] = "";
                }     
               
                $candidateData[$key]['id'] = $value->id;
                $candidateData[$key]['job_id'] = $value->job_form_id;
                $candidateData[$key]['first_name'] = $value->first_name;
                $candidateData[$key]['middle_name'] = $value->middle_name;
                $candidateData[$key]['last_name'] = $value->last_name;
                    if($value->gender == 1){
                        $candidateData[$key]['gender'] = "Male";
                    } else if($value->gender == 2){
                        $candidateData[$key]['gender'] = "Female";
                    }else{
                        $candidateData[$key]['gender'] = "Other";
                    }
                    if(!empty($value->profile_img)){
                        $candidateData[$key]['profile_image'] = DISPLAY_FULL_PROFILE_IMAGE_PATH.$value->profile_img;
                    }else{
                        $candidateData[$key]['profile_image'] = "";
                    }
                    if(!empty($value->profile_img)){
                        $candidateData[$key]['cv_document'] = DISPLAY_RESUME_PATH.$value->document_cv;
                    }else{
                        $candidateData[$key]['cv_document'] = "";
                    }
                    $candidateData[$key]['email_address'] = $value->email;
                    $candidateData[$key]['contact'] = $value->contact_number;
                    $candidateData[$key]['date_of_birth'] = $value->date_of_birth;
                    if($value->martial_status == 1){
                        $candidateData[$key]['martial_status'] = "Single";
                    } else if($value->martial_status == 2){
                        $candidateData[$key]['martial_status'] = "Married";
                    } else if($value->martial_status == 3){
                        $candidateData[$key]['martial_status'] = "Divorced";
                    }else{
                        $candidateData[$key]['martial_status'] = "N/A";
                    }
                    if($value->physically_challenged == 1){
                        $candidateData[$key]['physically_challenged'] = "Yes";
                    } else if($value->physically_challenged == 2){
                        $candidateData[$key]['physically_challenged'] = "No";
                    } else if($value->physically_challenged == 3){
                        $candidateData[$key]['physically_challenged'] = "Prefer not to say";
                    }else{
                        $candidateData[$key]['physically_challenged'] = "N/A";
                    }
                    // $candidateData[$key]['address'] = $value->address;
                    $candidateData[$key]['applied_date'] = $value->created_at->format('d-m-Y');
                
                
                $jobName = Job::where('id',$value->job_form_id)->value('title');
                if(!empty($jobName)){
                    $candidateData[$key]['jobAppliedFor'] = $jobName;
                } else{
                    $candidateData[$key]['jobAppliedFor'] = "Job not available";
                }
                
                $candidateData[$key]['offer_letter_status'] = $value->offer_letter_status;
                
                if($value->offer_letter_status == 1){
                    $candidateData[$key]['email_template_id'] = 2;
                } else{
                    $candidateData[$key]['email_template_id'] = 0;
                }
                
                $candidateData[$key]['on_boarding_status'] = $value->on_boarding_status;
                
                $education = CandidateEducation::where('candidate_job_apply_id', $value->id)->get();
                    $educationData = array();
                    foreach ($education as $eduKey => $eduValue) {
                        $educationData[$eduKey]['id'] = $eduValue->id;
                        $educationData[$eduKey]['qualification_id'] = Qualification::find($eduValue->qualification_id)->qualification_name;
                        $educationData[$eduKey]['course'] = $eduValue->course;
                        $educationData[$eduKey]['school_college'] = $eduValue->school_college;
                        $educationData[$eduKey]['city'] = $eduValue->city;
                        $educationData[$eduKey]['university_board'] = $eduValue->university_board;
                        $educationData[$eduKey]['passing_year'] = $eduValue->passing_year;
                    }
                    $candidateData[$key]['education'] = $educationData;
        
                    $experience = CandidateExperience::where('candidate_job_apply_id', $value->id)->get();
                    $experienceData = array();
                    foreach ($experience as $expKey => $expValue) {
                        
                        $designationName = Skill::where('type', 'Designation')->where('id', $expValue->designation)->value('skill_name');
                        if(!empty($designationName)){
                            $experienceData[$expKey]['designation'] = $designationName;
                        } else{
                            $experienceData[$expKey]['designation'] = $expValue->designation;
                        }
                        $experienceData[$expKey]['id'] = $expValue->id;
                        $experienceData[$expKey]['organisation_name'] = $expValue->organisation_name;
                        
                        $experienceData[$expKey]['reason_of_leaving'] = $expValue->reason_of_leaving;
                        $experienceData[$expKey]['start_date'] = $expValue->start_date;
                        $experienceData[$expKey]['end_date'] = $expValue->end_date;
                    }
                    $candidateData[$key]['experience'] = $experienceData;
                    
                    
                    $interviewDetails = CandidateInterviewSchedule::where('candidate_id', $value->id)->get();
                    $interviewJourney = array();
                    foreach($interviewDetails as $interviewKey => $interValue) {
                        
                        $candidateNameData = CandidateJobApply::where('id', $interValue->candidate_id)->select(['first_name', 'last_name'])->first();
                        $candidateName = $candidateNameData->first_name . ' ' . $candidateNameData->last_name;
                        
                        $employerNameData = Employer::where('id', $interValue->assigned_by)->select(['first_name', 'last_name'])->first();
                        $employerName = $employerNameData->first_name . ' ' . $employerNameData->last_name;
                        
                        $staffNameData = Staff::where('id', $interValue->assigned_to)->select(['first_name', 'last_name'])->first();
                        $staffName = $staffNameData->first_name . ' ' . $staffNameData->last_name;
                        
                        $jobName = Job::where('id', $interValue->job_id)->value('title');
                        
                        $processName = Process::where('id', $interValue->process_id)->value('process_name');
                        
                        $startTime = $interValue->start_time;

                        $formattedStartTime = date("g:i A", strtotime($startTime . ":00"));
                        
                        $interviewJourney[$interviewKey]['id'] = $interValue->id;
                        $interviewJourney[$interviewKey]['assigned_by'] = $interValue->assigned_by;
                        $interviewJourney[$interviewKey]['employer_name'] = $employerName;
                        $interviewJourney[$interviewKey]['assigned_to'] = $interValue->assigned_to;
                        $interviewJourney[$interviewKey]['staff_name'] = $staffName;
                        $interviewJourney[$interviewKey]['candidate_id'] = $interValue->candidate_id;
                        $interviewJourney[$interviewKey]['candidate_name'] = $candidateName;
                        $interviewJourney[$interviewKey]['job_id'] = $interValue->job_id;
                        $interviewJourney[$interviewKey]['job_name'] = $jobName;
                        $interviewJourney[$interviewKey]['process_id'] = $interValue->process_id;
                        $interviewJourney[$interviewKey]['process_name'] = $processName;
                        $interviewJourney[$interviewKey]['interview_type'] = $interValue->interview_type;

                        $interviewJourney[$interviewKey]['interview_type_details'] = $interValue->interview_type_details;
                        $interviewJourney[$interviewKey]['interview_date'] = $interValue->interview_date ? Carbon::parse($interValue->interview_date)->format('d M Y') : "Interview not scheduled";
                        $interviewJourney[$interviewKey]['start_time'] = $formattedStartTime;
                        $interviewJourney[$interviewKey]['duration'] = $interValue->duration;
                        $interviewJourney[$interviewKey]['comment'] = $interValue->comment;
                        $interviewJourney[$interviewKey]['round'] = $interValue->round;
                        $interviewJourney[$interviewKey]['interview_status'] = $interValue->interview_status;
                        $interviewJourney[$interviewKey]['interview_completion_status'] = $interValue->interview_completion_status;
                        $interviewJourney[$interviewKey]['interview_cancelation_status'] = $interValue->interview_cancelation_status;
                        $interviewJourney[$interviewKey]['interview_cancelation_reason'] = $interValue->interview_cancelation_reason;
                    }
                    
                    
                    
            
                    
                    $candidateData[$key]['interview_journey'] = $interviewJourney ?? [];
                    $candidateData[$key]['offer_letter_accepted'] = SelectedCandidate::where('candidate_id', $value->id)->value('offer_letter_accepted');
            }
            
            $status = StatusAttributes::where('status', 1)->get();
        
            // $data['candidatesData'] = $candidateData;
            // $data['statusList'] = $status;
            
            
            // $process = Process::where('employer_id', $currentUser)->orWhere('employer_id','0')->get();
            // $data['processList'] = $process;
    
            // $user = Staff::where('employer_id', $currentUser)->get();
            // $data['user'] = $user;
    
            return Response(['response' => $candidateData], 200);
            
        } else if(!empty($staffCheck)){
            $candidates = CandidateJobApply::where('staff_id', $currentUser)->get();
            $candidateData = array();

            foreach($candidates as $key => $value) {
                
                
            $candidateData[$key]['candidate_id'] = $value->id;
            $candidateData[$key]['job_id'] = $value->job_form_id;
            $candidateData[$key]['employer_id'] = $value->employer_id;
            $candidateData[$key]['staff_id'] = $value->staff_id;
            $candidateData[$key]['first_name'] = $value->first_name;
            $candidateData[$key]['last_name'] = $value->last_name;
            $candidateData[$key]['email'] = $value->email;
            $candidateData[$key]['phone'] = $value->contact_number;
            $candidateData[$key]['address'] = $value->address;
            $candidateData[$key]['gender'] = $value->gender;
            $candidateData[$key]['dateofbirth'] = $value->date_of_birth;
            $candidateData[$key]['martialstatus'] = $value->martial_status;
            $candidateData[$key]['physical_challenged'] = $value->physical_challenge;
            $candidateData[$key]['created'] = format_date($value->created);
            $candidateData[$key]['status'] = $value->status;
            $candidateData[$key]['interview_status'] = $value->interview_status;
            $candidateData[$key]['interviewDetails'] = getFeedbackData($value->id);
            $candidateData[$key]['jobAppliedFor'] = Job::where('id',$value->job_form_id)->value('title');

            }
    
            return Response(['response' => $candidateData], 200);
            
        }
        $candidateData = array();

        foreach($candidates as $key => $value) {
            
            $candidateData[$key]['candidate_id'] = $value->id;
             $candidateData[$key]['job_id'] = $value->job_form_id;
             $candidateData[$key]['employer_id'] = $value->employer_id;
             $candidateData[$key]['staff_id'] = $value->staff_id;
             $candidateData[$key]['first_name'] = $value->first_name;
            $candidateData[$key]['last_name'] = $value->last_name;
             $candidateData[$key]['email'] = $value->email;
             $candidateData[$key]['phone'] = $value->contact_number;
             $candidateData[$key]['address'] = $value->address;
            $candidateData[$key]['gender'] = $value->gender;
             $candidateData[$key]['dateofbirth'] = $value->date_of_birth;
             $candidateData[$key]['martialstatus'] = $value->martial_status;
             $candidateData[$key]['physical_challenged'] = $value->physical_challenge;
             $candidateData[$key]['created'] = format_date($value->created);
             $candidateData[$key]['status'] = $value->status;
             $candidateData[$key]['interview_status'] = $value->interview_status;
             $candidateData[$key]['interviewDetails'] = getFeedbackData($value->id);
        }

        return Response(['response' => $candidateData], 200);
    }
    
    public function addComment(Request $request) {
        $currentUser = Auth::user()->id;
        $adminCheck = Admin::where('id', $currentUser)->where('user_type',"admin")->first();
        $employerCheck = Employer::where('id', $currentUser)->where('user_type',"employer")->first();
        $staffCheck = Staff::where('id', $currentUser)->where('user_type',"staff")->first();
        $candidate = $request->candidate;
        $job_id = $request->job_id;
        
        if(!empty($adminCheck)) {
            $usertype = "admin";
        }else if(!empty($employerCheck)) {
            $usertype = "employer";
        }else if(!empty($staffCheck)){
            $usertype = "staff";
        }else{
            $usertype = "Not found";
        }
        
        $addComment = CandidateFeedback::insert([
            'job_id' => $job_id,
            'user_id' => $currentUser,
            'user_type' => $usertype,
            'candidate_id' => $request->candidate_id,
            'comment' => $request->comment,
        ]);
            
        

        return Response(['response' => "", 'message' => "Comment added successfully", 'status' => 200],200);
    }

    
    public function getCommentLog(Request $request, $id) {
        $currentUser = Auth::user()->id;
        $candidate = $request->candidate;
        $job_id = $request->job_id;
        $existingComments = CandidateFeedback::where('candidate_id', $id)->orderBy('id', 'desc')->get();
        $existingCommentData = array();
            
            
            foreach($existingComments as $key => $value) {
                if($value->user_type == "staff") {
                    $username = Staff::where('id', $value->user_id)
                                ->selectRaw("CONCAT(first_name, ' ', last_name) as full_name")
                                ->first();
                } else {
                    $username = Employer::where('id', $value->user_id)
                                ->selectRaw("CONCAT(first_name, ' ', last_name) as full_name")
                                ->first();
                }
                if(!empty($value->job_id)){
                    $existingCommentData[$key]['job_id'] = $value->job_id;
                    $existingCommentData[$key]['job_name'] = Job::where('id', $value->job_id)->value('title');
                } else{
                    $existingCommentData[$key]['job_id'] = "";
                    $existingCommentData[$key]['job_name'] = "";
                }
            // $existingCommentData[$key]['job_name'] = !empty($value->job_id) ? Job::where('id', $value->job_id)->value('title') : "";

                $existingCommentData[$key]['candidate_id'] = $value->candidate_id;
                
                $existingCommentData[$key]['comment'] = $value->comment;
                $existingCommentData[$key]['id'] = $value->id;
                $existingCommentData[$key]['user_name'] = $username ? $username->full_name : 'Unknown'; // Fetch full_name or handle null case
                $existingCommentData[$key]['user_type'] = $value->user_type; // Correcting key name to 'user_type'
                $existingCommentData[$key]['created'] = format_date($value->created);
                $existingCommentData[$key]['modified'] = format_date($value->modified);
            }

            return Response(['response' => $existingCommentData, 'status' => 200],200);
    }
    
    
    
    public function getUserlistForprocess(Request $request, $id) {
        // echo $id;
        $userList = DB::table('assign_users_to_processes')->where('process_id', $id)->get();      
        $userData = array();
        
        $currentUser = Auth::user()->id;
        // echo $currentUser;
        $adminCheck = Admin::where('id', $currentUser)->where('user_type',"admin")->first();
        $employerCheck = Employer::where('id', $currentUser)->where('user_type',"employer")->first();
        $staffCheck = Staff::where('id', $currentUser)->where('user_type',"staff")->first();

        foreach ($userList as $key => $value) {
            if(!empty($adminCheck)) {
                $user = Admin::find($value->user_id);
            } else if(!empty($employerCheck)) {
                $user = Staff::find($value->user_id);
            }
        
            // Check if user exists
            if ($user !== null) {
                $userData[$key]['id'] = $user->id;
                $userData[$key]['first_name'] = $user->first_name;
                $userData[$key]['last_name'] = $user->last_name;
            } else {
                
                // \Log::warning("User with ID {$value->user_id} not found in Admin model.");
            }
        }
        
        // Re-index the array numerically
        $userData = array_values($userData);
        return Response(['response' => $userData,  'message' => '', 'status' => 200], 200);
    }
    
    public function getProcessName(Request $request, $id) {
        $process = Process::where('id', $id)->first();
        if($process) {
            return Response(['response' => $process,  'message' => '', 'status' => 200], 200);
        }
    }

    public function getUserName(Request $request, $id) {
        $currentUser = Auth::user()->id;
        $adminCheck = Admin::where('id', $currentUser)->where('user_type',"admin")->first();
        $employerCheck = Employer::where('id', $currentUser)->where('user_type',"employer")->first();
        $staffCheck = Staff::where('id', $currentUser)->where('user_type',"staff")->first();
        
        if(!empty($adminCheck)){
            $user = Admin::where('id', $id)->first();
            if($user) {
                return Response(['response' => $user,  'message' => '', 'status' => 200], 200);
            } else{
                return Response(['response' => "Not found",  'message' => '', 'status' => 200], 200);
            }
        } else if(!empty($employerCheck)){
            $user = Staff::where('id', $id)->first();
            if($user) {
                return Response(['response' => $user,  'message' => '', 'status' => 200], 200);
            } else{
                return Response(['response' => "Not found",  'message' => '', 'status' => 200], 200);
            }
        }else if(!empty($staffCheck)){
            $user = Staff::where('id', $id)->first();
            if($user) {
                return Response(['response' => $user,  'message' => '', 'status' => 200], 200);
            } else{
                return Response(['response' => "Not found",  'message' => '', 'status' => 200], 200);
            }
        }
        
        
    }
}
