<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Category;
use App\Models\Currency;
use Illuminate\Support\Facades\Validator;
use App\Models\Employer;
use App\Models\Admin;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\DB;

class CurrenciesController extends Controller
{
    public function currencyListing(Request $request){
        $currentUser = Auth::user()->id;
        $data = array();
        
        $currencies = Currency::where('employer_id', $currentUser)->orderBy('id', 'Desc')->get();
        $currencyArray = array();
        foreach($currencies as $key => $currency) {
            $currencyArray[$key]['id'] = $currency->id;
            $currencyArray[$key]['slug'] = $currency->slug;
            $currencyArray[$key]['name'] = $currency->name;
            $currencyArray[$key]['code'] = $currency->code;
            $currencyArray[$key]['symbol'] = $currency->symbol;
            $currencyArray[$key]['symbol_place'] = $currency->symbol_place;
            $currencyArray[$key]['is_default'] = $currency->is_default;
            $currencyArray[$key]['status'] = $currency->status;
        }
        
        $data['currency'] = $currencyArray;
        
        return Response(['response' => $data, 'message' => 'success', 'status' => 200], 200);
    }
    
    public function currencyAdd(Request $request){
        
        $currentUser = Auth::user()->id;
        
        $validator = Validator::make($request->all(), [
            'name' => 'required|unique:currencies,name',
            'code' => 'required',
            'symbol' => 'required',
        ]);
        
        if($validator->fails()){
            return Response(['response' => $validator->errors(), 'message' => 'error', 'status' => 500], 200);
        } else{
            Currency::create([
                'employer_id' => $currentUser,
                'name' => $request->name,
                'code' => $request->code,
                'symbol' => $request->symbol,
                'symbol_place' =>'before',
                'is_default' => '0',
                'slug' => $this->createSlug($request->name,'currencies'),
                'status' => 1,
            ]);

            return Response(['response' => '' , 'message' => 'Currency Added Successfully' , 'status' => 200],200);
        }
    }
    
    public function currency_changeStatus($id) {
        $currentStatus = Currency::where('id', $id)->value('status');
        if($id != ''){
            if($currentStatus == 1){
                Currency::where('id', $id)->update([
                    'status' => 0,
                ]);
            }else{
                Currency::where('id', $id)->update([
                    'status' => 1,
                ]);
            }
            
            return Response(['response' => 'Activated Successfully', 'message' => 'Activated Successfully', 'status' => 200],200);
        }
        return Response(['response' => 'Id not found', 'message' => 'Id not found', 'status' => 500], 200);
    }
    
    
    public function currency_Delete($id){
        $currencyData = Currency::where('id', $id)->first();
        
        if(!empty($currencyData)){
            Currency::where('id', $id)->delete();
            
            return Response(['response' => 'Currency Deteled Successfully', 'message' => 'success', 'status' => 200], 200);
        }else{
            return Response(['response' => 'No record deleted', 'message' => 'No record deleted', 'status' => 500], 200);
        }
    }
    
    public function currency_Edit(Request $request,$id){
        $currencyData = Currency::where('id', $id)->first();
        
        if(!empty($request->all())){
            $validator = Validator::make($request->all(), [
                'name' => 'required',
                'code' => 'required',
                'symbol' => 'required',
            ]);
            
            if($validator->fails()){
                return Response(['response' => $validator->errors(), 'message' => 'error', 'status' => 500], 200);
            } else{
                Currency::where('id', $id)->update([
                    'name' => $request->name,
                    'code' => $request->code,
                    'symbol' => $request->symbol,
                ]);
                
                $currencyData = Currency::where('id', $id)->first();
                return Response(['response' => $currencyData , 'message'=> 'success' , 'status'=> 200 ],200);
            }
        }else{
             return Response(['response' => $currencyData , 'message' => 'sucess', 'status'=>200],200);
        }
    }
    
    public function is_default($id){
        if(!empty($id)){
            Currency::where('id', '!=', 0)->update([
                        'is_default' => 0,
                    ]);
            Currency::where('id',$id)->update([
                        'is_default' => 1,
            ]);

              
                $Keyword = Currency::where('id', '!=', 0)->get();
            return Response(['response' => $Keyword, 'message' => 'success', 'status' => 200], 200);
        }
        else{
            return Response(['response' => 'No record selected', 'message' => 'error', 'status' => 500], 200);
        }
    }
    
    // public function currency_deactivate($id) {
    //     if($id != ''){
    //         Currency::where('id', $id)->update([
    //             'status' => 0,
    //         ]);
            
    //         return Response(['response' => 'De-activated Successfully', 'message' => 'De-activated Successfully', 'status' => 200], 200);
    //     }
    //     return Response(['response' => 'Id not found', 'message' => 'Id not found', 'status' => 500], 200);
    // }
    
}
