<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use App\Models\Employer;
use App\Models\Admin;
use App\Models\Job;
use App\Models\Staff;
use App\Models\Skill;
use App\Models\SelectedCandidate;
use App\Models\CandidateJobApply;
use App\Models\CandidateEducation;
use App\Models\CandidateExperience;
use App\Models\Qualification;
use App\Models\OfferDraftData;
use App\Models\Certificate;
use Illuminate\Support\Facades\Auth;
use App\Models\Industry;
use Carbon\Carbon;

use Mail;
use App\Models\EmailTemplate;
use App\Mail\SendMail;


class EmailTemplateController extends Controller
{
    public function listingEmailTemplate(Request $request) {
        $data = array();
        
        $emails = EmailTemplate::orderBy('id', 'Desc')->get();
        $mails_array = array();
            foreach($emails as $key => $email) {
                $mails_array[$key]['id'] = $email->id;
                $mails_array[$key]['title'] = $email->title;
                $mails_array[$key]['static_email_heading'] = $email->static_email_heading;
                $mails_array[$key]['subject'] = $email->subject;
                $mails_array[$key]['variable'] = $email->variable;
                $mails_array[$key]['template'] = $email->template;
            }
        
        $data['email'] = $mails_array;
        
        return Response(['response' => $data, 'message' => 'success', 'status' => 200], 200);
    }
    
    public function editEmailTemplate(Request $request, $slug = null) {
        $emailTemplateArray = array();
        $emailTemplateData = EmailTemplate::where('id', $slug)->first();
        $emailTemplateArray['id'] = $emailTemplateData->id;
        $emailTemplateArray['slug'] = $emailTemplateData->static_email_heading;
        $emailTemplateArray['static_email_heading'] = $emailTemplateData->static_email_heading;
        $emailTemplateArray['title'] = $emailTemplateData->title;
        $emailTemplateArray['subject'] = $emailTemplateData->subject;
        $emailTemplateArray['variables'] = explode(',',$emailTemplateData->variable);
        $emailTemplateArray['template'] = $emailTemplateData->template;
        
        if(!empty($request->all())){
            $validator = Validator::make($request->all(), [
                'title' => 'required',
                'subject' => 'required',
                'template' => 'required',
            ]);
            
            if($validator->fails()){
                return Response(['response' => $validator->errors(), 'message' => 'error', 'status' => 500], 200);
            }else{
                 Emailtemplate::where('id',$slug)->update([
                    'title' => $request->title,
                    'subject' => $request->subject,
                    'template' => $request->template,
                ]);

                return Response(['response' => $emailTemplateArray , 'message'=> 'Announcement updated successfully' , 'status'=> 200 ],200);
            }
        }else {
            return Response(['response' => $emailTemplateArray, 'message' => 'success', 'status' => 200], 200);
        }
    }
    
    public function testEmailTemplate($slug) {
        
        $employerId = Auth::user()->id;
        $employerEmail = Employer::where('id', $employerId)->value('email_address');
        
        $emailTemplateData = EmailTemplate::where('id', $slug)->first();
        
         $logo = Employer::where('id', $employerId)->value('company_logo');
                
                if(!empty($logo)){
                    $logoPath = EMPLOYER_COMPANY_LOGO_DISPLAY_PATH . $logo;
                } else{
                    $logoPath = LOGO_PATH;
                }
        
        $emailSubject = $emailTemplateData->subject;
        $emailBody = $emailTemplateData->template;
        
        try {
            Mail::to($employerEmail)->send(new SendMail($emailBody, $emailSubject, $logoPath));
        } catch (\Exception $e) {
            return response()->json(['error' => 'Failed to send email.', 'message' => $e->getMessage()], 500);
        }
        
        return Response(['response' => 'Email Send Successfully', 'message' => 'Email Send Successfully', 'status' => 200], 200);
    }
}