<?php

use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use App\Models\Category;
use App\Models\Skill;
use App\Models\Qualification;
use App\Models\Industry;
use App\Models\CandidateFeedback;
use App\Models\Process;


if (!function_exists('createSlug')) {
    function createSlug($table,$field){
        $slug = Str::slug($field);
    
        if (DB::table($table)->where('slug', $slug)->exists()) {
            $suffix = 1;
            while (DB::table($table)->where('slug', $slug . '-' . $suffix)->exists()) {
                $suffix++;
            }
            $slug .= '-' . $suffix;
        }
    
        return $slug;
    }
}

if (!function_exists('format_date')) {
    function format_date($dateTimeString)
    {
        return Carbon::parse($dateTimeString)->format('F j, Y');
    }
}

if (!function_exists('getCategoryName')) {
    function getCategoryName($id) {
        $category = Category::where('id', $id)->first();
        return $category->category_name;
    }
}

// if (!function_exists('getDesignationName')) {
//     function getDesignationName($id) {
//         $designation = Skill::
//         where('id', $id)
//         ->where('type', 'Designation')
//         ->first();

//         return $designation->skill_name;
//     }
// }

if (!function_exists('getDesignationName')) {
    function getDesignationName($id) {
        if (is_null($id)) {
            return "Designation Not Available";
        }

        $designation = Skill::where('id', $id)
            ->where('type', 'Designation')
            ->first();

        return $designation->skill_name ?? "Designation Not Available";
    }
}


// if (!function_exists('getSkillName')) {
//     function getSkillName($id) {
//         $skill = Skill::
//         where('id', $id)
//         ->where('type', 'Skill')
//         ->first();

//         return $skill->skill_name;
//     }
// }

if (!function_exists('getSkillName')) {
    function getSkillName($id) {
        try {
            $skill = Skill::where('id', $id)
                ->where('type', 'Skill')
                ->first();

            if (!$skill) {
                throw new Exception('Skill not found');
            }

            return $skill->skill_name;
        } catch (Exception $e) {
            // Log the exception if needed
            \Log::error('Error in getSkillName: ' . $e->getMessage());
            // Return a default value or handle the error gracefully
            return 'Unknown Skill';
        }
    }
}

if (!function_exists('getProcessOrderName')) {
    function getProcessOrderName($id) {
        try {
            $process = Process::where('id', $id)
                ->first();

            if (!$process) {
                throw new Exception('Process not found');
            }

            return $process->process_name;
            
        } catch (Exception $e) {
            // Log the exception if needed
            \Log::error('Error in getProcessOrderName: ' . $e->getMessage());
            // Return a default value or handle the error gracefully
            return '';
        }
    }
}


if (!function_exists('getWorkTypeName')) {
    function getWorkTypeName($id) {
        if($id == 1) {
            return "Full Time";
        }
        if($id == 2) {
            return "Part Time";
        }
        if($id == 3) {
            return "Contractual";
        }
        if($id == 4) {
            return "Seasonal";
        }
        if($id == 5) {
            return "Casual";
        }
    }
}

if (!function_exists('getQualificationName')) {
    function getQualificationName($id) {
        $qualification = Qualification::where('id', $id)->first();
        if(empty($qualification)) {
            return "";
        }
        return $qualification->qualification_name;
    }
}

if (!function_exists('getIndustryName')) {
    function getIndustryName($id) {
        
        $industry = Industry::where('id', $id)->first();
        
        if(empty($industry)) {
            return "";
        }
        return $industry->industry_name;
    }
}

// if (!function_exists('getFeedbackData')) {
//     function getFeedbackData($id) {
//         $feedbackData = CandidateFeedback::where('candidate_id', $id)->get();
//         if(empty($feedbackData)) {
//             return "";
//         }
//         return $feedbackData;
//     }
// }

if (!function_exists('getFeedbackData')) {
    function getFeedbackData($id) {
        $feedbackData = CandidateFeedback::where('candidate_id', $id)
            ->join('admins', 'candidate_feedback.user_id', '=', 'admins.id')
            ->join('candidate_job_applies', 'candidate_feedback.candidate_id', '=', 'candidate_job_applies.id')
            ->select(
                'candidate_feedback.*',
                'admins.first_name as user_first_name',
                'admins.last_name as user_last_name',
                'candidate_job_applies.first_name as candidate_first_name',
                'candidate_job_applies.last_name as candidate_last_name'
            )
            ->get();
        
        if ($feedbackData->isEmpty()) {
            return "";
        }
        return $feedbackData;
    }
}

