<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CandidateProfile extends Model
{
    use HasFactory;

    protected $fillable = [
        'candidate_id',
        'resource_type',
        'profile_image_url',
        'education',
        'work',
        'skills',
        'projects',
        'achievements',
        'summary'
    ];
    

    protected $casts = [
        'education' => 'array',
        'work' => 'array',
        'skills' => 'array',
        'projects' => 'array',
        'achievements' => 'array',
    ];

    public function candidate()
    {
        return $this->belongsTo(Candidate::class);
    }
}