<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use App\Models\Qualification;
use App\Models\Employer;
use App\Models\Admin;
use Illuminate\Support\Facades\Auth;

class QualificationsController extends Controller
{
    //
    public function listing(Request $request)
    {
        $currentUser = Auth::user()->id;
        $currentUserCheck = Admin::where('id', $currentUser)->first();
        // echo $currentUser;
        if (!empty($currentUserCheck)) {
            // echo "From Admin";

            if ($request->filled('action')) {

                $idList = $request->idList;
                if ($idList) {
                    if ($request->action == 'activate') {
                        DB::table('qualifications')->whereIn('id', explode(',', $idList))->update(['status' => '1']);
                    } elseif ($request->action == 'deactivate') {
                        DB::table('qualifications')->whereIn('id', explode(',', $idList))->update(['status' => '0']);
                    } elseif ($request->action == 'delete') {
                        DB::table('qualifications')->whereIn('id', explode(',', $idList))->delete();
                    }
                }
            }

            $qualification = Qualification::orderBy('id', 'desc')->get();

            $qualificationData = array();
            foreach ($qualification as $key => $value) {

                $employerName = "System Generated";
                if ($value->employer_id != 0) {
                    $employerRecord = Employer::where('id', $value->employer_id)->first();
                    if (!empty($employerRecord)) {
                        $employerName = $employerRecord->first_name . " " . $employerRecord->last_name;
                    }
                }

                $qualificationData[$key]['qualification_id'] = $value->id;
                $qualificationData[$key]['qualification_name'] = $value->qualification_name;
                $qualificationData[$key]['employer_name'] = $employerName;
                $qualificationData[$key]['slug'] = $value->slug;
                $qualificationData[$key]['status'] = $value->status;
                $qualificationData[$key]['created'] = format_date($value->created_at);
            }
        } else {

            // Multiple activate/deactivate/delete
            if ($request->filled('action')) {

                $idList = $request->idList;
                if ($idList) {
                    if ($request->action == 'activate') {
                        // DB::table('qualifications')->whereIn('id', explode(',', $idList))->update(['status' => '1']);
                        $idList = $request->idList; // Assuming $idList is comma-separated IDs

                        // Update qualifications with status = '1'
                        DB::table('qualifications')->whereIn('id', explode(',', $idList))->update(['status' => '1']);

                        // Fetch the updated qualifications
                        $qualifications = DB::table('qualifications')->whereIn('id', explode(',', $idList))->get();

                        foreach ($qualifications as $qualification) {
                            $employerStatus = $qualification->employer_status;

                            // Convert the comma-separated string into an array
                            $employerStatusArray = explode(',', $employerStatus);

                            // Check if the current user's ID is in the array
                            if (($key = array_search($currentUser, $employerStatusArray)) !== false) {
                                // Remove the user ID from the array
                                unset($employerStatusArray[$key]);

                                // Convert the array back to a comma-separated string
                                $updatedEmployerStatus = implode(',', $employerStatusArray);

                                // Update the qualification's employer status
                                DB::table('qualifications')->where('id', $qualification->id)->update(['employer_status' => $updatedEmployerStatus]);
                            }
                        }
                    } elseif ($request->action == 'deactivate') {
                        // DB::table('qualifications')->whereIn('id', explode(',', $idList))->update(['status' => '0']);

                        $idList = $request->idList; // Assuming $idList is comma-separated IDs

                        // Update qualifications with status = '1'
                        // DB::table('qualifications')->whereIn('id', explode(',', $idList))->update(['status' => '0']);

                        // Fetch the updated qualifications
                        $qualifications = DB::table('qualifications')->whereIn('id', explode(',', $idList))->get();

                        foreach ($qualifications as $qualification) {
                            $employerStatus = $qualification->employer_status;

                            // Convert the comma-separated string into an array
                            $employerStatusArray = explode(',', $employerStatus);



                            // Check if the current user's ID is not in the array
                            if (!in_array($currentUser, $employerStatusArray)) {
                                // Add the user ID to the array
                                $employerStatusArray[] = $currentUser;

                                // Convert the array back to a comma-separated string
                                $updatedEmployerStatus = implode(',', $employerStatusArray);

                                // Update the qualification's employer status
                                DB::table('qualifications')->where('id', $qualification->id)->update(['employer_status' => $updatedEmployerStatus]);
                            }
                        }
                    } elseif ($request->action == 'delete') {
                        DB::table('qualifications')->whereIn('id', explode(',', $idList))->delete();
                    }
                }
            }

            $qualification = Qualification::where(function ($query) use ($currentUser) {
                $query->where('employer_id', $currentUser)
                    ->orWhere('employer_id', 0);
            })
                ->where('status', 1)
                ->orderBy('id', 'desc')
                ->get();

            $qualificationData = array();
            foreach ($qualification as $key => $value) {
                $employerStatusArray = explode(',', $value->employer_status);

                // Check if the current user's ID is in the employer_status array
                $userPresent = in_array($currentUser, $employerStatusArray);

                $qualificationData[$key]['qualification_id'] = $value->id;
                $qualificationData[$key]['qualification_name'] = $value->qualification_name;
                $qualificationData[$key]['slug'] = $value->slug;
                $qualificationData[$key]['employer_status'] = $value->employer_status;
                $qualificationData[$key]['status'] = $userPresent ? 0 : 1; // Set status based on user presence
                $qualificationData[$key]['created'] = format_date($value->created_at);
            }
        }
        //$qualification = Qualification::orderBy('id','desc')->get();






        return Response(['response' => $qualificationData, 'status' => 200], 200);
    }


    public function addQualification(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'qualification_name' => 'required|unique:qualifications,qualification_name',
        ]);

        $validator->setAttributeNames([
            'qualification_name' => 'Qualification Name',
        ]);

        if ($validator->fails()) {
            $msg = $this->validatersErrorString($validator->errors());
            return Response(['response' => "", 'message' => $msg, 'status' => 500], 200);
        } else {

            // Generate slug from qualification name
            $slug = Str::slug($request->qualification_name);

            $currentUser = Auth::user()->id;
            $currentUserCheck = Admin::where('id', $currentUser)->first();
            // echo $currentUser;
            if (!empty($currentUserCheck)) {
                $qualification = Qualification::insert([
                    'qualification_name' => $request->qualification_name,
                    'slug' => $slug,
                    'status' => 1,
                    'employer_id' => 0
                ]);
            } else {
                $qualification = Qualification::insert([
                    'qualification_name' => $request->qualification_name,
                    'slug' => $slug,
                    'status' => 1,
                    'employer_id' => $currentUser
                ]);
            }

            // $qualification = Qualification::insert([
            //     'qualification_name' => $request->qualification_name,
            //     'slug' => $slug, // Store the slug in the database
            //     'status' => 1
            // ]);

            return Response(['response' => $qualification, 'message' => 'Qualification added successfully', 'status' => 200], 200);
        }
    }

    public function editQualification(Request $request, $slug)
    {
        $qualification = Qualification::where('slug', $slug)->first();
        if (!empty($request->all())) {
            $validator = Validator::make($request->all(), [
                'qualification_name' => 'required|unique:qualifications,qualification_name',
            ]);

            $validator->setAttributeNames([
                'qualification_name' => 'Qualification Name',
            ]);

            if ($validator->fails()) {
                $msg = $this->validatersErrorString($validator->errors());
                return Response(['response' => "", 'message' => $msg, 'status' => 500], 200);
            } else {
                // Generate slug from qualification name    
                $qualification = Qualification::where('slug', $request->slug)->update([
                    'qualification_name' => $request->qualification_name,
                    'slug' => Str::slug($request->qualification_name), // Store the slug in the database
                ]);

                return Response(['response' => $qualification, 'message' => 'Qualification updated successfully', 'status' => 200], 200);
            }
        } else {
            return Response(['response' => $qualification, 'message' => '', 'status' => 200], 200);
        }
    }

    public function deleteQualification($slug)
    {
        $qualificationData = Qualification::where('slug', $slug)->first();

        $currentUser = Auth::user()->id;
        $currentUserCheck = Admin::where('id', $currentUser)->first();
        // echo $currentUser;
        if (!empty($currentUserCheck)) {
            //admin
            if (!empty($qualificationData)) {
                Qualification::where('slug', $slug)->delete();
                $msgString = 'Qualification deleted successfully';
                return Response(['response' => $msgString, 'message' => $msgString, 'status' => 200], 200);
            } else {

                $msgString = 'No record deleted';
                return Response(['response' => $msgString, 'message' => $msgString, 'status' => 500], 200);
            }
        } else {
            //employer
            if ($qualificationData->employer_id != 0) {
                // echo "hi";
                Qualification::where('slug', $slug)->delete();
                $msgString = 'Qualification deleted successfully';
                return Response(['response' => $msgString, 'message' => $msgString, 'status' => 200], 200);
            } else {
                return Response(['response' => "", 'message' => "This is a system generated qualification and cannot be deleted", 'status' => 500], 200);
            }
        }
    }

    public function activateQualification($slug)
    {

        $currentUser = Auth::user()->id;
        $currentUserCheck = Admin::where('id', $currentUser)->first();
        // echo $currentUser;
        if (!empty($currentUserCheck)) {
            $qualificationData = DB::table('qualifications')->where('slug', $slug)->first();
            if (!empty($qualificationData)) {
                DB::table('qualifications')->where('slug', $slug)->update([
                    'status' => 1
                ]);
                return Response(['response' => "", 'message' => 'Qualification activated successfully', 'status' => 200], 200);
            }
        } else {
            // Employer login
            $qualification = Qualification::where('slug', $slug)->first();
            if (!empty($qualification)) {
                $employerStatus = $qualification->employer_status;

                // Convert the comma-separated string into an array
                $employerStatusArray = explode(',', $employerStatus);

                // Check if the user ID is in the array
                if (($key = array_search($currentUser, $employerStatusArray)) !== false) {
                    // Remove the user ID from the array
                    unset($employerStatusArray[$key]);

                    // Convert the array back to a comma-separated string
                    $updatedEmployerStatus = implode(',', $employerStatusArray);

                    // Update the qualification's employer status
                    $qualification->employer_status = $updatedEmployerStatus;

                    // Save the changes to the database
                    $qualification->save();
                }
            }
        }

        return Response(['response' => '', 'message' => "Qualification activated successfully", 'status' => 200], 200);
    }

    public function deactivateQualification($slug)
    {
        $currentUser = Auth::user()->id;
        $currentUserCheck = Admin::where('id', $currentUser)->first();
        // echo $currentUser;
        if (!empty($currentUserCheck)) {
            $qualificationData = DB::table('qualifications')->where('slug', $slug)->first();
            if (!empty($qualificationData)) {
                DB::table('qualifications')->where('slug', $slug)->update([
                    'status' => 0
                ]);
                return Response(['response' => "", 'message' => 'Qualification deactivated successfully', 'status' => 200], 200);
            }
        } else {
            // Employer login
            $qualification = Qualification::where('slug', $slug)->first();
            if (!empty($qualification)) {
                $employerStatus = $qualification->employer_status;

                // Convert the comma-separated string into an array
                $employerStatusArray = explode(',', $employerStatus);

                // Check if the user ID is in the array
                if (!in_array($currentUser, $employerStatusArray)) {
                    // Add the user ID to the array
                    $employerStatusArray[] = $currentUser;

                    // Convert the array back to a comma-separated string
                    $updatedEmployerStatus = implode(',', $employerStatusArray);

                    // Update the qualification's employer status
                    $qualification->employer_status = $updatedEmployerStatus;

                    // Save the changes to the database
                    $qualification->save();
                }
            }
        }
        return Response(['response' => '', 'message' => "Qualification deactivated successfully", 'status' => 200], 200);
    }
}
