<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use App\Models\Employer;
use App\Models\Admin;
use App\Models\Job;
use App\Models\Staff;
use App\Models\Skill;
use App\Models\Currency;
use App\Models\SelectedCandidate;
use App\Models\CandidateJobApply;
use App\Models\CandidateEducation;
use App\Models\CandidateExperience;
use App\Models\CandidateInterviewSchedule;
use App\Models\Qualification;
use App\Models\OfferDraftData;
use App\Models\Certificate;
use Illuminate\Support\Facades\Auth;
use App\Models\Industry;
use Carbon\Carbon;

use Mail;
use App\Models\EmailTemplate;
use App\Mail\SendMail;


class EmailTemplateController extends Controller
{
    public function listingEmailTemplate(Request $request) {
        $data = array();
        
        $emails = EmailTemplate::orderBy('id', 'Desc')->get();
        $mails_array = array();
            foreach($emails as $key => $email) {
                $mails_array[$key]['id'] = $email->id;
                $mails_array[$key]['title'] = $email->title;
                $mails_array[$key]['static_email_heading'] = $email->static_email_heading;
                $mails_array[$key]['subject'] = $email->subject;
                $mails_array[$key]['variable'] = $email->variable;
                $mails_array[$key]['template'] = $email->template;
            }
        
        $data['email'] = $mails_array;
        
        return Response(['response' => $data, 'message' => 'success', 'status' => 200], 200);
    }
    
    public function editEmailTemplate(Request $request, $slug = null) {
        $emailTemplateArray = array();
        $emailTemplateData = EmailTemplate::where('id', $slug)->first();
        $emailTemplateArray['id'] = $emailTemplateData->id;
        $emailTemplateArray['slug'] = $emailTemplateData->static_email_heading;
        $emailTemplateArray['static_email_heading'] = $emailTemplateData->static_email_heading;
        $emailTemplateArray['title'] = $emailTemplateData->title;
        $emailTemplateArray['subject'] = $emailTemplateData->subject;
        $emailTemplateArray['variables'] = explode(',',$emailTemplateData->variable);
        $emailTemplateArray['template'] = $emailTemplateData->template;
        
        if(!empty($request->all())){
            $validator = Validator::make($request->all(), [
                'title' => 'required',
                'subject' => 'required',
                'template' => 'required',
            ]);
            
            if($validator->fails()){
                return Response(['response' => $validator->errors(), 'message' => 'error', 'status' => 500], 200);
            }else{
                 Emailtemplate::where('id',$slug)->update([
                    'title' => $request->title,
                    'subject' => $request->subject,
                    'template' => $request->template,
                ]);

                return Response(['response' => $emailTemplateArray , 'message'=> 'Announcement updated successfully' , 'status'=> 200 ],200);
            }
        }else {
            return Response(['response' => $emailTemplateArray, 'message' => 'success', 'status' => 200], 200);
        }
    }
    
    public function testEmailTemplate($slug) {
        
        $employerId = Auth::user()->id;
        $employerEmail = Employer::where('id', $employerId)->value('email_address');
        
        $emailTemplateData = EmailTemplate::where('id', $slug)->first();
        
         $logo = Employer::where('id', $employerId)->value('company_logo');
                
                if(!empty($logo)){
                    $logoPath = EMPLOYER_COMPANY_LOGO_DISPLAY_PATH . $logo;
                } else{
                    $logoPath = LOGO_PATH;
                }
        
        $emailSubject = $emailTemplateData->subject;
        $emailBody = $emailTemplateData->template;
        
        try {
            Mail::to($employerEmail)->send(new SendMail($emailBody, $emailSubject, $logoPath));
        } catch (\Exception $e) {
            return response()->json(['error' => 'Failed to send email.', 'message' => $e->getMessage()], 500);
        }
        
        return Response(['response' => 'Email Send Successfully', 'message' => 'Email Send Successfully', 'status' => 200], 200);
    }
    
    public function getOfferLetterEmailTemplatePreview(Request $request, $id){
        $emailTemplate = EmailTemplate::where('id', $id)->first();
        $userData = $request->input('userData');
        
        if($request->user_type == 'staff'){
           
           $staffId = Auth::user()->id;
           
           $employerId = Staff::where('id', $staffId)->value('employer_id');
        
            $currency = Currency::where('employer_id', $employerId)->where('is_default', '1')->first();
            
            // return response(['response' => $staffId, 'status' => 200], 200);
            
            
            $candidateId = $userData['candidate_id'] ?? null;
            $positionName = $userData['position_name'] ?? null;
            $companyName = $userData['company_name'] ?? null;
            $joiningDate = $userData['joining_date'] ?? null;
            
            $formattedDate = '';
    
            if ($joiningDate) {
                $formattedDate = date('d F, Y', strtotime($joiningDate));
                // echo $formattedDate; // Output: 14 May, 2025
            }
    
            $workLocation = $userData['work_location'] ?? null;
            $compensation = $currency->symbol . ' ' .$userData['compensation'] ?? null;
            $comment = $userData['comment'] ?? null;
            $jobTitle = $userData['job_title'] ?? null; 
            $panelLink = $userData['panel_link'] ?? null;
            
            $staffId = $userData['reporting_person'] ?? null;
            
            $staff = Staff::where('id', $staffId)->select('first_name', 'last_name')->first();
            $reportingPerson = $staff->first_name . ' ' . $staff->last_name;
            
            $candidate = CandidateJobApply::where('id', $candidateId)->select('first_name', 'last_name')->first();
            $candidateName = $candidate->first_name . ' ' . $candidate->last_name;
            
            
            $companyName = Employer::where('id', $employerId)->value('company_name');
            $logo = Employer::where('id', $employerId)->value('company_logo');
            
            
            if(!empty($logo)){
                $logoPath = EMPLOYER_COMPANY_LOGO_DISPLAY_PATH . $logo;
            } else{
                $logoPath = LOGO_PATH;
            }
            
            
            $html = '<table width="710" align="center" style="table-layout:fixed; font-family:Arial, Helvetica, sans-serif; border:1px solid #537286; box-shadow: 0 0 5px #537286; padding:10px 15px;">
                    <tbody><tr>
                            <td valign="top" style=" background-color: #e3e3e3;">
                                <table width="100%">
                                    <tbody><tr>
                                            <td>
                                                <a href="{{HTTP_PATH_FRONTEND}}">
                                                    
                                                    <img src="' . $logoPath . '" alt="' . SITE_TITLE . '">
                                                </a>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </td>
                        </tr>
                        <tr>
                            <td valign="top">
                                <table width="100%">
                                    <tbody>
                                        <tr>
                                            <td>
                                                <p style="font-size: 15px; font-weight: bold; color: #000000;">Dear ' . $candidateName . ',</p>
                <p style="font-size: 13px; line-height: 18px; margin-top: 10px; color: black !important;">I hope this email finds you
                    well. On behalf of <span style="font-weight: bold">' . $companyName . '</span>, I am pleased to offer you the position of ' . $positionName . '. We are excited
                    about the skills, experience, and enthusiasm you bring to the team.</p>
                <p style="font-size: 13px; line-height: 18px; margin-top: 10px; color: black !important;">Below are the key details of your offer:</p>
                <table width="100%">
                    <tbody>
                        <tr>
                            <td style="color:#434343; font-size:13px; line-height:18px;">
                                <p style="color:#434343;margin:10px 0 0;"><strong
                                        style="font-family: arial,helvetica,sans-serif; color: black;">Position:- </strong>
                                        ' . $positionName . '</p>
                                <p style="color:#434343;margin:10px 0 0;"><strong
                                        style="font-family: arial,helvetica,sans-serif; color: black;">Reporting To:- </strong>
                                        ' . $reportingPerson . '</p>
                                <p style="color:#434343;margin:10px 0 0;"><strong
                                        style="font-family: arial,helvetica,sans-serif; color: black;">Start Date:- </strong>
                                        ' . $formattedDate . '</p>
                                <p style="color:#434343;margin:10px 0 0;"><strong
                                        style="font-family: arial,helvetica,sans-serif; color: black;">Work Location:- </strong>
                                        ' . $workLocation . '</p>
                                <p style="color:#434343;margin:10px 0 0;"><strong
                                        style="font-family: arial,helvetica,sans-serif; color: black;">Compensation:- </strong>
                                        ' . $compensation . '</p>
                                <p style="color:#434343;margin:10px 0 0;"><strong
                                        style="font-family: arial,helvetica,sans-serif; color: black;">Comment:- </strong>
                                        ' . $comment . '</p>
                            </td>
                        </tr>
                    </tbody>
                </table>
                <p style="font-size: 13px; line-height: 18px; margin-top: 10px; color: black !important;">Please find the formal offer letter attached for your reference, which includes detailed information about your role, responsibilities, and employment terms. We request you to review the document carefully.</p>
                
                <p style="font-size: 13px; line-height: 18px; margin-top: 10px; color: black !important;">To confirm your decision regarding this offer, please click the link below:</p>
                <p style="font-size: 13px; line-height: 18px; margin-top: 10px; color: #007BFF !important;">
                    <a href="' . $panelLink . '" style="color: blue">Submit Your Decision</a>
                </p>
                
                <p style="font-size: 13px; line-height: 18px; margin-top: 10px; color: black !important;">We are thrilled at the prospect of you joining our team and contributing to our success. Welcome aboard!</p>
                <p style="font-size: 13px; line-height: 18px; margin-top: 10px; color: black !important;">Looking forward to hearing from you.</p>
                <p style="font-size: 13px; line-height: 18px; margin-top: 10px; color: black !important;">Warm Regards,<br>Team
                    RMS Logicspice</p>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="color:#434343; font-size:13px; line-height:18px;">
                                                <p style="color:#434343; margin:10px 0 0;">If you need any assistance, please e-mail us at <a style="color:#000; text-decoration: underline;" href="mailto:' . MAIL_FROM .'">' . MAIL_FROM .'</a>.</p>
                
                                                <p style="color:#002859;font:bold 15px Arial, Helvetica, sans-serif; margin:10px 0 0;"> The ' . SITE_TITLE .' Team</p>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <!-- Begin Footer Notifications -->
                                <table width="100%" style="border-top:1px solid #ddd;">
                                    <tbody><tr>
                                            <td style="font-size:11px; line-height:18px;">
                                                <p style="margin:10px 0 0;">*Note: Any automatically generated mails from ' . SITE_TITLE . ' may include one-click link which you can go right into the site without having to log in. Please do not forward this mail to anyone as you do not want anyone else to abuse your account!</p>
                                            </td>
                                        </tr>
                                    </tbody></table>
                                <!-- End Footer Notifications -->
                            </td>
                        </tr>
                        <tr>
                            <td valign="top">
                                <!-- Begin Footer -->
                                <table width="100%" style="border-top:1px solid #ddd; background-color:#e3e3e3; color: #0B0B0B;">
                                    <tbody><tr>
                                            <td style="font-size:12px;">
                                                <p style="color:#333; width:100%;">Copyright &copy; 2025 LSRMS All Rights Reserved.</p>
                                                <!--<p style="color:#FFFFFF;margin:10px 0 10px;">&nbsp;<a href="#" style="color:#FFFFFF;">Disclaimer</a>&nbsp; | &nbsp;<a href="#" style="color:#FFFFFF;">Terms & Conditions</a>&nbsp; | &nbsp;<a href="#" style="color:#FFFFFF;">Our Service Policy</a></p>-->
                                            </td>
                                            <td align="right">
                                                <a href="' .HTTP_PATH_FRONTEND . '">
                                                    <img src="' . $logoPath. '" alt="' . SITE_TITLE . '">
                                                </a>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                <!-- End Footer -->
                            </td>
                        </tr>
                    </tbody>
                </table>';
           
            
        } else{
           
           $employerId = Auth::user()->id;
        
            $currency = Currency::where('employer_id', $employerId)->where('is_default', '1')->first();
            
            
            $candidateId = $userData['candidate_id'] ?? null;
            $positionName = $userData['position_name'] ?? null;
            $companyName = $userData['company_name'] ?? null;
            $joiningDate = $userData['joining_date'] ?? null;
            
            $formattedDate = '';
    
            if ($joiningDate) {
                $formattedDate = date('d F, Y', strtotime($joiningDate));
                // echo $formattedDate; // Output: 14 May, 2025
            }
    
            $workLocation = $userData['work_location'] ?? null;
            $compensation = $currency->symbol . ' ' .$userData['compensation'] ?? null;
            $comment = $userData['comment'] ?? null;
            $jobTitle = $userData['job_title'] ?? null; 
            $panelLink = $userData['panel_link'] ?? null;
            
            $staffId = $userData['reporting_person'] ?? null;
            
            $staff = Staff::where('id', $staffId)->select('first_name', 'last_name')->first();
            $reportingPerson = $staff->first_name . ' ' . $staff->last_name;
            
            $candidate = CandidateJobApply::where('id', $candidateId)->select('first_name', 'last_name')->first();
            $candidateName = $candidate->first_name . ' ' . $candidate->last_name;
            
            
            $companyName = Employer::where('id', $employerId)->value('company_name');
            $logo = Employer::where('id', $employerId)->value('company_logo');
            
            
            if(!empty($logo)){
                $logoPath = EMPLOYER_COMPANY_LOGO_DISPLAY_PATH . $logo;
            } else{
                $logoPath = LOGO_PATH;
            }
            
            
            $html = '<table width="710" align="center" style="table-layout:fixed; font-family:Arial, Helvetica, sans-serif; border:1px solid #537286; box-shadow: 0 0 5px #537286; padding:10px 15px;">
                    <tbody><tr>
                            <td valign="top" style=" background-color: #e3e3e3;">
                                <table width="100%">
                                    <tbody><tr>
                                            <td>
                                                <a href="{{HTTP_PATH_FRONTEND}}">
                                                    
                                                    <img src="' . $logoPath . '" alt="' . SITE_TITLE . '">
                                                </a>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </td>
                        </tr>
                        <tr>
                            <td valign="top">
                                <table width="100%">
                                    <tbody>
                                        <tr>
                                            <td>
                                                <p style="font-size: 15px; font-weight: bold; color: #000000;">Dear ' . $candidateName . ',</p>
                <p style="font-size: 13px; line-height: 18px; margin-top: 10px; color: black !important;">I hope this email finds you
                    well. On behalf of <span style="font-weight: bold">' . $companyName . '</span>, I am pleased to offer you the position of ' . $positionName . '. We are excited
                    about the skills, experience, and enthusiasm you bring to the team.</p>
                <p style="font-size: 13px; line-height: 18px; margin-top: 10px; color: black !important;">Below are the key details of your offer:</p>
                <table width="100%">
                    <tbody>
                        <tr>
                            <td style="color:#434343; font-size:13px; line-height:18px;">
                                <p style="color:#434343;margin:10px 0 0;"><strong
                                        style="font-family: arial,helvetica,sans-serif; color: black;">Position:- </strong>
                                        ' . $positionName . '</p>
                                <p style="color:#434343;margin:10px 0 0;"><strong
                                        style="font-family: arial,helvetica,sans-serif; color: black;">Reporting To:- </strong>
                                        ' . $reportingPerson . '</p>
                                <p style="color:#434343;margin:10px 0 0;"><strong
                                        style="font-family: arial,helvetica,sans-serif; color: black;">Start Date:- </strong>
                                        ' . $formattedDate . '</p>
                                <p style="color:#434343;margin:10px 0 0;"><strong
                                        style="font-family: arial,helvetica,sans-serif; color: black;">Work Location:- </strong>
                                        ' . $workLocation . '</p>
                                <p style="color:#434343;margin:10px 0 0;"><strong
                                        style="font-family: arial,helvetica,sans-serif; color: black;">Compensation:- </strong>
                                        ' . $compensation . '</p>
                                <p style="color:#434343;margin:10px 0 0;"><strong
                                        style="font-family: arial,helvetica,sans-serif; color: black;">Comment:- </strong>
                                        ' . $comment . '</p>
                            </td>
                        </tr>
                    </tbody>
                </table>
                <p style="font-size: 13px; line-height: 18px; margin-top: 10px; color: black !important;">Please find the formal offer letter attached for your reference, which includes detailed information about your role, responsibilities, and employment terms. We request you to review the document carefully.</p>
                
                <p style="font-size: 13px; line-height: 18px; margin-top: 10px; color: black !important;">To confirm your decision regarding this offer, please click the link below:</p>
                <p style="font-size: 13px; line-height: 18px; margin-top: 10px; color: #007BFF !important;">
                    <a href="' . $panelLink . '" style="color: blue">Submit Your Decision</a>
                </p>
                
                <p style="font-size: 13px; line-height: 18px; margin-top: 10px; color: black !important;">We are thrilled at the prospect of you joining our team and contributing to our success. Welcome aboard!</p>
                <p style="font-size: 13px; line-height: 18px; margin-top: 10px; color: black !important;">Looking forward to hearing from you.</p>
                <p style="font-size: 13px; line-height: 18px; margin-top: 10px; color: black !important;">Warm Regards,<br>Team
                    RMS Logicspice</p>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="color:#434343; font-size:13px; line-height:18px;">
                                                <p style="color:#434343; margin:10px 0 0;">If you need any assistance, please e-mail us at <a style="color:#000; text-decoration: underline;" href="mailto:' . MAIL_FROM .'">' . MAIL_FROM .'</a>.</p>
                
                                                <p style="color:#002859;font:bold 15px Arial, Helvetica, sans-serif; margin:10px 0 0;"> The ' . SITE_TITLE .' Team</p>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <!-- Begin Footer Notifications -->
                                <table width="100%" style="border-top:1px solid #ddd;">
                                    <tbody><tr>
                                            <td style="font-size:11px; line-height:18px;">
                                                <p style="margin:10px 0 0;">*Note: Any automatically generated mails from ' . SITE_TITLE . ' may include one-click link which you can go right into the site without having to log in. Please do not forward this mail to anyone as you do not want anyone else to abuse your account!</p>
                                            </td>
                                        </tr>
                                    </tbody></table>
                                <!-- End Footer Notifications -->
                            </td>
                        </tr>
                        <tr>
                            <td valign="top">
                                <!-- Begin Footer -->
                                <table width="100%" style="border-top:1px solid #ddd; background-color:#e3e3e3; color: #0B0B0B;">
                                    <tbody><tr>
                                            <td style="font-size:12px;">
                                                <p style="color:#333; width:100%;">Copyright &copy; 2025 LSRMS All Rights Reserved.</p>
                                                <!--<p style="color:#FFFFFF;margin:10px 0 10px;">&nbsp;<a href="#" style="color:#FFFFFF;">Disclaimer</a>&nbsp; | &nbsp;<a href="#" style="color:#FFFFFF;">Terms & Conditions</a>&nbsp; | &nbsp;<a href="#" style="color:#FFFFFF;">Our Service Policy</a></p>-->
                                            </td>
                                            <td align="right">
                                                <a href="' .HTTP_PATH_FRONTEND . '">
                                                    <img src="' . $logoPath. '" alt="' . SITE_TITLE . '">
                                                </a>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                <!-- End Footer -->
                            </td>
                        </tr>
                    </tbody>
                </table>';
           
            
        }
        
        return response(['response' => $html, 'message' => 'success', 'status' => 200], 200);
        
    }
    
    
    public function getOnboardingFormEmailTemplatePreview(Request $request, $id){
        $emailTemplate = EmailTemplate::where('id', $id)->first();
        $employerId = Auth::user()->id;
        
        $candidateId = $request->candidate_id;
        
        $link = HTTP_PATH_FRONTEND . "/onboarding/" . $employerId . "/welcome/" . $candidateId;
        $companyName =  Employer::where('id', $employerId)->value('company_name');
        $employerEmail = Employer::where('id', $employerId)->value('email_address');
        
        $candidateData = CandidateJobApply::where('id', $candidateId)->first();
       
        $candidateName = trim(
            ($candidateData['first_name'] ?? '') . ' ' . ($candidateData['middle_name'] ?? '') . ' ' . ($candidateData['last_name'] ?? '')
        );
        
        $joiningDate = SelectedCandidate::where('candidate_id', $candidateId)->value('joining_date');
        
        $logo = Employer::where('id', $employerId)->value('company_logo');
        
        if(!empty($logo)){
            $logoPath = EMPLOYER_COMPANY_LOGO_DISPLAY_PATH . $logo;
        } else{
            $logoPath = LOGO_PATH;
        }
        
        $html = '<table width="710" align="center" style="table-layout:fixed; font-family:Arial, Helvetica, sans-serif; border:1px solid #537286; box-shadow: 0 0 5px #537286; padding:10px 15px;">
                <tbody><tr>
                        <td valign="top" style=" background-color: #e3e3e3;">
                            <table width="100%">
                                <tbody><tr>
                                        <td>
                                            <a href="{{HTTP_PATH_FRONTEND}}">
                                                
                                                <img src="' . $logoPath . '" alt="' . SITE_TITLE . '">
                                            </a>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </td>
                    </tr>
                    <tr>
                        <td valign="top">
                            <table width="100%">
                                <tbody>
                                    <tr>
                                        <td>
                                        
                                        <p><strong>Dear ' . $candidateName . ',</strong></p>
            <p>We’re thrilled to officially welcome you to ' . $companyName . '! We’re excited to have you on board and look forward to working together.</p>
            <p>To get started, please complete the onboarding process by clicking the link below:</p>
            <p>👉 <a href="'. $link .'" rel="noopener noreferrer" target="_blank">Start Onboarding Process</a></p>
            <p>This link will guide you through the necessary steps, including submitting essential documents, filling out forms, and learning about our company policies. Next Steps:</p>
            <p> Click on the link above to access your onboarding portal.</p>
            <p> Complete the tasks listed in the portal.</p>
            <p> If you have any questions or encounter any issues during the process, don’t hesitate to reach out to our HR team at '. $employerEmail .'.</p>
            <p>We’re looking forward to your first day on '. $joiningDate .' and can’t wait for you to join the team!</p>
            <p>Warm Regards,</p>
            <p>Team RMS Logicspice</p>
                                        
                                        
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="color:#434343; font-size:13px; line-height:18px;">
                                            <p style="color:#434343; margin:10px 0 0;">If you need any assistance, please e-mail us at <a style="color:#000; text-decoration: underline;" href="mailto:' . MAIL_FROM .'">' . MAIL_FROM .'</a>.</p>
            
                                            <p style="color:#002859;font:bold 15px Arial, Helvetica, sans-serif; margin:10px 0 0;"> The ' . SITE_TITLE .' Team</p>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <!-- Begin Footer Notifications -->
                            <table width="100%" style="border-top:1px solid #ddd;">
                                <tbody><tr>
                                        <td style="font-size:11px; line-height:18px;">
                                            <p style="margin:10px 0 0;">*Note: Any automatically generated mails from ' . SITE_TITLE . ' may include one-click link which you can go right into the site without having to log in. Please do not forward this mail to anyone as you do not want anyone else to abuse your account!</p>
                                        </td>
                                    </tr>
                                </tbody></table>
                            <!-- End Footer Notifications -->
                        </td>
                    </tr>
                    <tr>
                        <td valign="top">
                            <!-- Begin Footer -->
                            <table width="100%" style="border-top:1px solid #ddd; background-color:#e3e3e3; color: #0B0B0B;">
                                <tbody><tr>
                                        <td style="font-size:12px;">
                                            <p style="color:#333; width:100%;">Copyright &copy; 2025 LSRMS All Rights Reserved.</p>
                                            <!--<p style="color:#FFFFFF;margin:10px 0 10px;">&nbsp;<a href="#" style="color:#FFFFFF;">Disclaimer</a>&nbsp; | &nbsp;<a href="#" style="color:#FFFFFF;">Terms & Conditions</a>&nbsp; | &nbsp;<a href="#" style="color:#FFFFFF;">Our Service Policy</a></p>-->
                                        </td>
                                        <td align="right">
                                            <a href="' .HTTP_PATH_FRONTEND . '">
                                                <img src="' . $logoPath. '" alt="' . SITE_TITLE . '">
                                            </a>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                            <!-- End Footer -->
                        </td>
                    </tr>
                </tbody>
            </table>';
        
        
        return Response(['response' => $html, 'message' => 'success', 'status' => 200], 200);
        
    }
    
    
    public function getInterviewScheduleEmailTemplatePreview(Request $request, $id){
        $emailTemplate = EmailTemplate::where('id', $id)->first();
        $employerId = Auth::user()->id;
        
        $candidateId = $request->candidate_id;
        $jobId = $request->job_id;
        $processId = $request->process_id;
        $interviewType = $request->interview_type;
        $interviewTypeDetails = $request->interview_type_detail;
        $staffId = explode(',',$request->user_assigned);
        $comment = $request->comment;
        // $interviewStatus = $request->interview_status;
        $startTime = date("g:i A", strtotime($request->start_time . ":00"));
        $duration = $request->duration;
        $interviewDate = Carbon::parse($request->interview_date)->format('d M, Y');
        
        $candidate = CandidateJobApply::where('id', $candidateId)->select('first_name', 'last_name')->first();
        $candidateName = $candidate ? $candidate->first_name . ' ' . $candidate->last_name : '';
        
        $employerCompanyName = Employer::where('id', $employerId)->value('company_name');
        
        // $interviewer = Staff::where('id', $request->user_assigned)->select('first_name', 'last_name')->first();
        // $interviewerName = $interviewer ? $interviewer->first_name . ' ' . $interviewer->last_name : '';
        
        
        $interviewerName = Staff::whereIn('id', $staffId)
                            ->get(['first_name', 'last_name']) // Get both columns
                            ->map(function ($user) {
                                return $user->first_name . ' ' . $user->last_name; // Concatenate first & last name
                            })
                            ->implode(', '); // Convert array to a comma-separated string

        
        if ($duration == 1) {
            $formattedDuration = $duration . ' Hour';
        } else {
            $formattedDuration = $duration . ' Minutes';
        }
        
        $logo = Employer::where('id', $employerId)->value('company_logo');
        
        if(!empty($logo)){
            $logoPath = EMPLOYER_COMPANY_LOGO_DISPLAY_PATH . $logo;
        } else{
            $logoPath = LOGO_PATH;
        }
        
        // return Response(['response' => $logoPath, 'message' => '', 'status' => 200], 200);
        // exit();
        
        
        $html = '<table width="710" align="center" style="table-layout:fixed; font-family:Arial, Helvetica, sans-serif; border:1px solid #537286; box-shadow: 0 0 5px #537286; padding:10px 15px;">
                <tbody><tr>
                        <td valign="top" style=" background-color: #e3e3e3;">
                            <table width="100%">
                                <tbody><tr>
                                        <td>
                                            <a href="{{HTTP_PATH_FRONTEND}}">
                                                
                                                <img src="' . $logoPath . '" alt="' . SITE_TITLE . '">
                                            </a>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </td>
                    </tr>
                    <tr>
                        <td valign="top">
                            <table width="100%">
                                <tbody>
                                    <tr>
                                        <td>
                                        
                                        
                                        <p style=" font-size: 15px; font-weight: bold; color: #000000;">Dear '. $candidateName .',</p>

                                        <p style="font-size: 13px; line-height: 18px; margin-top: 10px; color: black !important;">We are pleased to invite you for an interview with <strong>'. $employerCompanyName .'</strong>. Below are the details:</p>
                                        <table width="100%">
                                            <tbody>
                                                <tr>
                                                    <td style="color:#434343; font-size:13px; line-height:18px;">
                                                        <p style="color:#434343;margin:10px 0 0;"><strong
                                                                style="font-family: arial,helvetica,sans-serif;   color: black;">Date:- </strong>
                                                                '.$interviewDate.'</p>
                                                        <p style="color:#434343;margin:10px 0 0;"><strong
                                                                style="font-family: arial,helvetica,sans-serif;   color: black;">Time:- </strong>
                                                                '.$startTime.'</p>
                                                        <p style="color:#434343;margin:10px 0 0;"><strong
                                                                style="font-family: arial,helvetica,sans-serif;   color: black;">Mode of Interview:- </strong>
                                                                '.$interviewType.'</p>
                                                        <p style="color:#434343;margin:10px 0 0;"><strong
                                                                style="font-family: arial,helvetica,sans-serif;   color: black;">Link/Location:- </strong>
                                                                '.$interviewTypeDetails.'</p>
                                                        <p style="color:#434343;margin:10px 0 0;"><strong
                                                                style="font-family: arial,helvetica,sans-serif;   color: black;">Duration:- </strong>
                                                                '.$formattedDuration.'</p>
                                                            <p style="color:#434343;margin:10px 0 0;"><strong
                                                                style="font-family: arial,helvetica,sans-serif;   color: black;">Interviewer:- </strong>
                                                                '.$interviewerName.'</p>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                        <strong>Preparation:</strong>
                                        <p style="font-size: 13px; line-height: 18px; margin-top: 10px; color: black !important;">Please come prepared to discuss your qualifications and experiences. If attending virtually, ensure you have a stable internet connection and working equipment.</p>
                                        <p style="font-size: 13px; line-height: 18px; margin-top: 10px; color: black !important;">We look forward to speaking with you!</p>
                                        
                                        <p style="font-size: 13px; line-height: 18px; margin-top: 10px; color: black !important;">Best Regards,<br>Team
                                            RMS Logicspice</p>
                                        
                                        
                                        
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="color:#434343; font-size:13px; line-height:18px;">
                                            <p style="color:#434343; margin:10px 0 0;">If you need any assistance, please e-mail us at <a style="color:#000; text-decoration: underline;" href="mailto:' . MAIL_FROM .'">' . MAIL_FROM .'</a>.</p>
            
                                            <p style="color:#002859;font:bold 15px Arial, Helvetica, sans-serif; margin:10px 0 0;"> The ' . SITE_TITLE .' Team</p>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <!-- Begin Footer Notifications -->
                            <table width="100%" style="border-top:1px solid #ddd;">
                                <tbody><tr>
                                        <td style="font-size:11px; line-height:18px;">
                                            <p style="margin:10px 0 0;">*Note: Any automatically generated mails from ' . SITE_TITLE . ' may include one-click link which you can go right into the site without having to log in. Please do not forward this mail to anyone as you do not want anyone else to abuse your account!</p>
                                        </td>
                                    </tr>
                                </tbody></table>
                            <!-- End Footer Notifications -->
                        </td>
                    </tr>
                    <tr>
                        <td valign="top">
                            <!-- Begin Footer -->
                            <table width="100%" style="border-top:1px solid #ddd; background-color:#e3e3e3; color: #0B0B0B;">
                                <tbody><tr>
                                        <td style="font-size:12px;">
                                            <p style="color:#333; width:100%;">Copyright &copy; 2025 LSRMS All Rights Reserved.</p>
                                            <!--<p style="color:#FFFFFF;margin:10px 0 10px;">&nbsp;<a href="#" style="color:#FFFFFF;">Disclaimer</a>&nbsp; | &nbsp;<a href="#" style="color:#FFFFFF;">Terms & Conditions</a>&nbsp; | &nbsp;<a href="#" style="color:#FFFFFF;">Our Service Policy</a></p>-->
                                        </td>
                                        <td align="right">
                                            <a href="' .HTTP_PATH_FRONTEND . '">
                                                <img src="' . $logoPath. '" alt="' . SITE_TITLE . '">
                                            </a>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                            <!-- End Footer -->
                        </td>
                    </tr>
                </tbody>
            </table>';
        
        
        return Response(['response' => $html, 'message' => 'success', 'status' => 200], 200);
        
    }
    
    
    public function getInterviewCancellationEmailTemplatePreview(Request $request, $id){
        $emailTemplate = EmailTemplate::where('id', $id)->first();
        
        $employerId = Auth::user()->id;
        
        $cancellationData = $request->input('cancellationData');
        
        
        $candidateId = $cancellationData['candidate_id'];
        
        // return response(['response' => $request->candidate_id, 'status' => 200], 200);
        // exit();
        
        $processId = $cancellationData['process_id'];
        $jobId = $cancellationData['job_id'];
        $reason = $cancellationData['reason'];
        
        $candidate = CandidateJobApply::where('id', $candidateId)->select(['first_name', 'last_name'])->first();
        $candidateName = $candidate->first_name . ' ' . $candidate->last_name;
        
        $interviewData = CandidateInterviewSchedule::where('candidate_id', $candidateId)->where('job_id', $jobId)->where('process_id', $processId)->first();
        
        $interviewDate = Carbon::parse($interviewData->interview_date)->format('d M, Y');
        
        $startTime = $interviewData->start_time; 
        $formattedStartTime = date("g:i A", strtotime($startTime . ":00"));
        
        $positionName = Job::where('id', $jobId)->value('title');
        $companyName = Employer::where('id', $employerId)->value('company_name');
        $employerEmail = Employer::where('id', $employerId)->value('email_address');
        
        
        $logo = Employer::where('id', $employerId)->value('company_logo');
        
        if(!empty($logo)){
            $logoPath = EMPLOYER_COMPANY_LOGO_DISPLAY_PATH . $logo;
        } else{
            $logoPath = LOGO_PATH;
        }
        
        $html = '<table width="710" align="center" style="table-layout:fixed; font-family:Arial, Helvetica, sans-serif; border:1px solid #537286; box-shadow: 0 0 5px #537286; padding:10px 15px;">
                <tbody><tr>
                        <td valign="top" style=" background-color: #e3e3e3;">
                            <table width="100%">
                                <tbody><tr>
                                        <td>
                                            <a href="{{HTTP_PATH_FRONTEND}}">
                                                
                                                <img src="' . $logoPath . '" alt="' . SITE_TITLE . '">
                                            </a>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </td>
                    </tr>
                    <tr>
                        <td valign="top">
                            <table width="100%">
                                <tbody>
                                    <tr>
                                        <td>
                                        
                                        
                                        <p style=" font-size: 15px; font-weight: bold; color: #000000;">Dear '.$candidateName.',</p>

<p style="font-size: 13px; line-height: 18px; margin-top: 10px; color: black !important;">I hope this email finds you well. I am writing to inform you that, unfortunately, we need to cancel the interview scheduled for '.$interviewDate.' and '.$formattedStartTime.' for the '.$positionName.' role.</p>

<p style="font-size: 13px; line-height: 18px; margin-top: 10px; color: black !important;">We truly appreciate your interest in '.$companyName.' and the time you have taken to prepare for this opportunity. At this moment, due to '.$reason.', we are unable to proceed as planned.</p>
<p style="font-size: 13px; line-height: 18px; margin-top: 10px; color: black !important;">We apologize for any inconvenience this may cause and assure you that this decision was not made lightly. [If applicable: We may reach out to reschedule at a later date or keep your profile on file for future opportunities.]</p>


<p style="font-size: 13px; line-height: 18px; margin-top: 10px; color: black !important;">Thank you for your understanding. If you have any questions or require further clarification, please donot hesitate to contact me at <a style="color:#000; text-decoration: underline;" href="mailto:'.$employerEmail.'">'.$employerEmail.'</a>.</p>

<p style="font-size: 13px; line-height: 18px; margin-top: 10px; color: black !important;">Wishing you all the best in your career endeavors.</p>

<p style="font-size: 13px; line-height: 18px; margin-top: 10px; color: black !important;">Best Regards,<br>Team
    RMS Logicspice</p>
                                        
                                        
                                        
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="color:#434343; font-size:13px; line-height:18px;">
                                            <p style="color:#434343; margin:10px 0 0;">If you need any assistance, please e-mail us at <a style="color:#000; text-decoration: underline;" href="mailto:' . MAIL_FROM .'">' . MAIL_FROM .'</a>.</p>
            
                                            <p style="color:#002859;font:bold 15px Arial, Helvetica, sans-serif; margin:10px 0 0;"> The ' . SITE_TITLE .' Team</p>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <!-- Begin Footer Notifications -->
                            <table width="100%" style="border-top:1px solid #ddd;">
                                <tbody><tr>
                                        <td style="font-size:11px; line-height:18px;">
                                            <p style="margin:10px 0 0;">*Note: Any automatically generated mails from ' . SITE_TITLE . ' may include one-click link which you can go right into the site without having to log in. Please do not forward this mail to anyone as you do not want anyone else to abuse your account!</p>
                                        </td>
                                    </tr>
                                </tbody></table>
                            <!-- End Footer Notifications -->
                        </td>
                    </tr>
                    <tr>
                        <td valign="top">
                            <!-- Begin Footer -->
                            <table width="100%" style="border-top:1px solid #ddd; background-color:#e3e3e3; color: #0B0B0B;">
                                <tbody><tr>
                                        <td style="font-size:12px;">
                                            <p style="color:#333; width:100%;">Copyright &copy; 2025 LSRMS All Rights Reserved.</p>
                                            <!--<p style="color:#FFFFFF;margin:10px 0 10px;">&nbsp;<a href="#" style="color:#FFFFFF;">Disclaimer</a>&nbsp; | &nbsp;<a href="#" style="color:#FFFFFF;">Terms & Conditions</a>&nbsp; | &nbsp;<a href="#" style="color:#FFFFFF;">Our Service Policy</a></p>-->
                                        </td>
                                        <td align="right">
                                            <a href="' .HTTP_PATH_FRONTEND . '">
                                                <img src="' . $logoPath. '" alt="' . SITE_TITLE . '">
                                            </a>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                            <!-- End Footer -->
                        </td>
                    </tr>
                </tbody>
            </table>';
        
        
        return Response(['response' => $html, 'message' => 'success', 'status' => 200], 200);
        
        
    }
    
    
    
}